/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.service;

import com.google.inject.Singleton;
import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.entities.events.EventInterface;
import com.snaju.nebula.entities.task.NebulaTask;
import com.snaju.nebula.service.LogServiceOld;
import com.snaju.nebula.service.Service;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Singleton
public class TaskService
implements Service<TaskService>,
EventInterface {
    private final ConcurrentHashMap<UUID, NebulaTask> tasks = new ConcurrentHashMap();
    private final ExecutorService asyncPool = Executors.newFixedThreadPool(4);
    private Long nextTaskTrigger = 0L;
    private Long tps = 20L;
    private long currentTick = 0L;

    @Override
    public void init() {
        System.out.println("Tick-based TaskService initialized at 20 TPS");
    }

    public void scheduleTask(NebulaTask task) {
        this.tasks.put(task.getUuid(), task);
    }

    public Long milliFromTps() {
        return 1000L / this.tps;
    }

    public void tick() {
        if (System.currentTimeMillis() >= this.nextTaskTrigger) {
            Long tickStart = System.currentTimeMillis();
            Long nextTick = System.currentTimeMillis() + this.milliFromTps();
            for (NebulaTask t : this.tasks.values()) {
                if (t.isCanceled()) {
                    this.tasks.remove(t.getUuid());
                    continue;
                }
                if (!t.isReady()) continue;
                if (t.isAsync()) {
                    this.asyncPool.submit(() -> {
                        t.run();
                        t.tick();
                    });
                    continue;
                }
                t.run();
                t.tick();
            }
            this.nextTaskTrigger = nextTick;
        }
    }

    public static long secondsToTicks(long seconds) {
        return seconds * 20L;
    }

    public static long millisToTicks(long millis) {
        return millis / 50L;
    }

    public void cancelTask(UUID taskId) {
        this.tasks.remove(taskId);
    }

    @Override
    public String getName() {
        return "TaskService";
    }

    @Override
    public void register(TaskService obj) {
    }

    @Override
    public LogServiceOld getLogger() {
        return (LogServiceOld)SpaceSDK.getInstance().getInjector().getInstance(LogServiceOld.class);
    }
}

