/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.sockets;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import lowentry.ue4.classes.sockets.SocketConnection;
import lowentry.ue4.classes.sockets.SocketConnectionListener;
import lowentry.ue4.classes.sockets.SocketMessageUdpType;
import lowentry.ue4.library.LowEntry;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroClient;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.events.PyroClientListener;
import lowentry.ue4.libs.pyronet.lowentry.pyronet.udp.event.PyroClientUdpListener;

public class SocketConnectionHandler
implements PyroClientListener,
PyroClientUdpListener {
    protected final SocketConnectionListener socketListener;
    protected final SocketConnection connection;
    protected ConnectingStage connectingStage = ConnectingStage.WAITING_FOR_CONNECTION;
    protected ByteBuffer receivingHandshakeUdpId = null;
    protected byte[] handshakeUdpId = null;
    protected boolean socketListenerCalledConnected = false;
    protected boolean stopReceivingAnything = false;
    protected ReceivingStage receivingStage = ReceivingStage.RECEIVE_TYPE;
    protected byte receivingType = 0;
    protected int receivingFunctionCallId = 0;
    protected int receivingPacketSize = 0;
    protected byte[] receivingPacket = null;
    protected int receivingPacketPosition = 0;
    protected ByteBuffer receivedIntegerBuffer = ByteBuffer.allocate(4);

    public SocketConnectionHandler(SocketConnectionListener socketListener, SocketConnection connection) {
        this.socketListener = socketListener;
        this.connection = connection;
    }

    @Override
    public void unconnectableClient(PyroClient client) {
        if (this.connectingStage == ConnectingStage.WAITING_FOR_CONNECTION) {
            this.connectingStage = ConnectingStage.UNCONNECTABLE;
        }
    }

    @Override
    public void connectedClient(PyroClient client) {
        if (this.connectingStage == ConnectingStage.WAITING_FOR_CONNECTION) {
            this.connectingStage = ConnectingStage.WAITING_FOR_UDP_HANDSHAKE_ID;
        }
    }

    public void skipUdpHandshake() {
        if (this.connectingStage == ConnectingStage.WAITING_FOR_UDP_HANDSHAKE_ID) {
            this.connectingStage = ConnectingStage.CONNECTED;
        }
    }

    public void callConnected() {
        if (!this.socketListenerCalledConnected) {
            this.socketListenerCalledConnected = true;
            this.socketListener.connected(this.connection);
        }
    }

    @Override
    public void droppedClient(PyroClient client, IOException cause) {
        this.stopReceivingAnything = true;
        this.receivingPacket = null;
        this.receivedIntegerBuffer = null;
        this.receivingHandshakeUdpId = null;
        this.connectingStage = ConnectingStage.UNCONNECTABLE;
        if (this.socketListenerCalledConnected) {
            this.socketListener.disconnected(this.connection);
        }
        this.connection.failAllFunctionCalls();
    }

    @Override
    public void disconnectedClient(PyroClient client) {
        this.stopReceivingAnything = true;
        this.receivingPacket = null;
        this.receivedIntegerBuffer = null;
        this.receivingHandshakeUdpId = null;
        this.connectingStage = ConnectingStage.UNCONNECTABLE;
        if (this.socketListenerCalledConnected) {
            this.socketListener.disconnected(this.connection);
        }
        this.connection.failAllFunctionCalls();
    }

    @Override
    public void sentData(PyroClient client, int bytes) {
    }

    public void disconnect() {
        this.stopReceivingAnything = true;
        this.receivingPacket = null;
        this.receivedIntegerBuffer = null;
        this.receivingHandshakeUdpId = null;
        this.connectingStage = ConnectingStage.UNCONNECTABLE;
        this.connection.disconnect();
    }

    @Override
    public void receivedDataUdp(ByteBuffer data) {
        if (this.stopReceivingAnything) {
            return;
        }
        if (!data.hasRemaining()) {
            return;
        }
        byte packetType = data.get();
        switch (packetType) {
            case 1: {
                if (this.connectingStage != ConnectingStage.WAITING_FOR_UDP_HANDSHAKE_RESPONSE) {
                    return;
                }
                byte[] id = new byte[data.remaining() + 1];
                id[0] = 1;
                data.get(id, 1, data.remaining());
                if (LowEntry.areBytesEqual(id, this.handshakeUdpId)) {
                    this.handshakeUdpId = null;
                    this.connectingStage = ConnectingStage.CONNECTED;
                }
                return;
            }
            case 2: {
                if (!this.socketListenerCalledConnected || this.connection.connectionUdp == null) {
                    return;
                }
                byte[] bytes = new byte[data.remaining()];
                data.get(bytes);
                this.socketListener.receivedUnreliableMessage(this.connection, bytes);
                return;
            }
            case 3: {
                if (this.connection.connectionUdp == null) {
                    return;
                }
                this.connection.connectionUdp.write(ByteBuffer.wrap(SocketMessageUdpType.PONG_BYTES));
                return;
            }
            case 4: {
                return;
            }
        }
    }

    protected int receiveUint(ByteBuffer data) {
        if (!data.hasRemaining()) {
            return -1;
        }
        if (this.receivedIntegerBuffer.position() == 0) {
            byte firstByte = data.get();
            if ((firstByte >> 7 & 1) == 0) {
                return firstByte & 0xFF;
            }
            this.receivedIntegerBuffer.put(firstByte);
        }
        while (data.hasRemaining() && this.receivedIntegerBuffer.position() < 4) {
            this.receivedIntegerBuffer.put(data.get());
        }
        if (this.receivedIntegerBuffer.position() < 4) {
            return -1;
        }
        this.receivedIntegerBuffer.flip();
        byte b1 = this.receivedIntegerBuffer.get();
        byte b2 = this.receivedIntegerBuffer.get();
        byte b3 = this.receivedIntegerBuffer.get();
        byte b4 = this.receivedIntegerBuffer.get();
        this.receivedIntegerBuffer.clear();
        int value = (b1 & 0xFF & 0xFFFFFF7F) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
        if (value <= 127) {
            this.disconnect();
            return -1;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedData(PyroClient client, ByteBuffer data) {
        if (this.stopReceivingAnything) {
            return;
        }
        while (data.hasRemaining()) {
            Map<Integer, Object> map;
            int receivedUint;
            if (this.connectingStage == ConnectingStage.WAITING_FOR_UDP_HANDSHAKE_ID) {
                if (this.receivingHandshakeUdpId == null) {
                    this.receivingHandshakeUdpId = ByteBuffer.allocate(data.get() & 0xFF);
                }
                while (data.hasRemaining() && this.receivingHandshakeUdpId.hasRemaining()) {
                    this.receivingHandshakeUdpId.put(data.get());
                }
                if (this.receivingHandshakeUdpId.hasRemaining()) continue;
                this.receivingHandshakeUdpId.flip();
                this.handshakeUdpId = new byte[this.receivingHandshakeUdpId.remaining()];
                this.receivingHandshakeUdpId.get(this.handshakeUdpId);
                this.receivingHandshakeUdpId = null;
                this.connectingStage = ConnectingStage.WAITING_FOR_UDP_HANDSHAKE_RESPONSE;
                continue;
            }
            if (this.connectingStage == ConnectingStage.WAITING_FOR_UDP_HANDSHAKE_RESPONSE) {
                this.disconnect();
                return;
            }
            if (this.receivingStage == ReceivingStage.RECEIVE_TYPE) {
                this.receivingType = data.get();
                if (this.receivingType == 1) {
                    this.receivingStage = ReceivingStage.RECEIVE_PACKET_SIZE;
                } else if (this.receivingType == 3) {
                    this.receivingStage = ReceivingStage.RECEIVE_FUNCTION_CALL_ID;
                } else if (this.receivingType == 5) {
                    this.receivingStage = ReceivingStage.RECEIVE_FUNCTION_CALL_ID;
                } else if (this.receivingType == 6) {
                    this.receivingStage = ReceivingStage.RECEIVE_FUNCTION_CALL_ID;
                } else {
                    this.disconnect();
                    return;
                }
            }
            if (this.receivingStage == ReceivingStage.RECEIVE_FUNCTION_CALL_ID) {
                receivedUint = this.receiveUint(data);
                if (receivedUint < 0) {
                    return;
                }
                this.receivingFunctionCallId = receivedUint;
                if (this.receivingType == 6) {
                    SocketConnection.InternalLatentFunctionCall functionCall;
                    map = this.connection.latentFunctionCalls;
                    synchronized (map) {
                        functionCall = this.connection.latentFunctionCalls.remove(this.receivingFunctionCallId);
                    }
                    if (functionCall != null) {
                        if (functionCall.latentAction != null) {
                            functionCall.latentAction.canceledByServer();
                        }
                        if (functionCall.listener != null) {
                            this.connection.canceledLatentFunctionCall(functionCall.listener);
                        }
                    }
                    this.receivingStage = ReceivingStage.RECEIVE_TYPE;
                } else {
                    this.receivingStage = ReceivingStage.RECEIVE_PACKET_SIZE;
                }
            }
            if (this.receivingStage == ReceivingStage.RECEIVE_PACKET_SIZE) {
                receivedUint = this.receiveUint(data);
                if (receivedUint < 0) {
                    return;
                }
                this.receivingPacketSize = receivedUint;
                this.receivingPacket = new byte[this.receivingPacketSize];
                this.receivingStage = ReceivingStage.RECEIVE_PACKET;
            }
            if (this.receivingStage != ReceivingStage.RECEIVE_PACKET) continue;
            if (!data.hasRemaining()) {
                return;
            }
            int packetBytesRemaining = this.receivingPacketSize - this.receivingPacketPosition;
            if (data.remaining() <= packetBytesRemaining) {
                int length = data.remaining();
                data.get(this.receivingPacket, this.receivingPacketPosition, length);
                this.receivingPacketPosition += length;
            } else {
                data.get(this.receivingPacket, this.receivingPacketPosition, packetBytesRemaining);
                this.receivingPacketPosition += packetBytesRemaining;
            }
            if (this.receivingPacketPosition < this.receivingPacketSize) continue;
            if (this.receivingType == 1) {
                this.socketListener.receivedMessage(this.connection, this.receivingPacket);
            } else if (this.receivingType == 3) {
                SocketConnection.InternalFunctionCall functionCall;
                map = this.connection.functionCalls;
                synchronized (map) {
                    functionCall = this.connection.functionCalls.remove(this.receivingFunctionCallId);
                }
                if (functionCall != null && functionCall.listener != null) {
                    this.connection.receivedResponseFunctionCall(functionCall.listener, this.receivingPacket);
                }
            } else if (this.receivingType == 5) {
                SocketConnection.InternalLatentFunctionCall functionCall;
                map = this.connection.latentFunctionCalls;
                synchronized (map) {
                    functionCall = this.connection.latentFunctionCalls.remove(this.receivingFunctionCallId);
                }
                if (functionCall != null) {
                    if (functionCall.latentAction != null) {
                        functionCall.latentAction.done();
                    }
                    if (functionCall.listener != null) {
                        this.connection.receivedResponseLatentFunctionCall(functionCall.listener, this.receivingPacket);
                    }
                }
            } else {
                this.disconnect();
                return;
            }
            this.receivingStage = ReceivingStage.RECEIVE_TYPE;
            this.receivingPacket = null;
            this.receivingPacketPosition = 0;
        }
    }

    protected static enum ConnectingStage {
        WAITING_FOR_CONNECTION,
        UNCONNECTABLE,
        WAITING_FOR_UDP_HANDSHAKE_ID,
        WAITING_FOR_UDP_HANDSHAKE_RESPONSE,
        CONNECTED;

    }

    protected static enum ReceivingStage {
        RECEIVE_TYPE,
        RECEIVE_FUNCTION_CALL_ID,
        RECEIVE_PACKET_SIZE,
        RECEIVE_PACKET;

    }
}

