/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.internal.rsa;

import java.util.Arrays;
import lowentry.ue4.classes.internal.rsa.RsaBigInteger;
import lowentry.ue4.classes.internal.rsa.RsaSignedMutableBigInteger;

class RsaMutableBigInteger {
    private int[] value;
    public int intLen;
    private int offset = 0;
    private static final RsaMutableBigInteger ONE = new RsaMutableBigInteger(1);
    private static final int KNUTH_POW2_THRESH_LEN = 6;
    private static final int KNUTH_POW2_THRESH_ZEROS = 3;
    private static final long LONG_MASK = 0xFFFFFFFFL;

    public RsaMutableBigInteger() {
        this.value = new int[1];
        this.intLen = 0;
    }

    public RsaMutableBigInteger(int val) {
        this.value = new int[1];
        this.intLen = 1;
        this.value[0] = val;
    }

    public RsaMutableBigInteger(int[] val) {
        if (val == null) {
            this.value = new int[1];
            this.intLen = 0;
            return;
        }
        this.value = val;
        this.intLen = val.length;
    }

    public RsaMutableBigInteger(RsaBigInteger b) {
        if (b == null) {
            this.value = new int[1];
            this.intLen = 0;
            return;
        }
        this.intLen = b.mag.length;
        this.value = Arrays.copyOf(b.mag, this.intLen);
    }

    public RsaMutableBigInteger(RsaMutableBigInteger val) {
        if (val == null) {
            this.value = new int[1];
            this.intLen = 0;
            return;
        }
        this.intLen = val.intLen;
        this.value = Arrays.copyOfRange(val.value, val.offset, val.offset + this.intLen);
    }

    private static int si(int a, int b) {
        return a >>> b;
    }

    private static long sl(long a, int b) {
        return a >>> b;
    }

    private void ones(int n) {
        if (n > this.value.length) {
            this.value = new int[n];
        }
        Arrays.fill(this.value, -1);
        this.offset = 0;
        this.intLen = n;
    }

    private int[] getMagnitudeArray() {
        if (this.offset > 0 || this.value.length != this.intLen) {
            return Arrays.copyOfRange(this.value, this.offset, this.offset + this.intLen);
        }
        return this.value;
    }

    public RsaBigInteger toBigInteger(int sign) {
        if (this.intLen == 0 || sign == 0) {
            return RsaBigInteger.ZERO;
        }
        return new RsaBigInteger(this.getMagnitudeArray(), sign);
    }

    public RsaBigInteger toBigInteger() {
        this.normalize();
        return this.toBigInteger(this.isZero() ? 0 : 1);
    }

    private void clear() {
        this.intLen = 0;
        this.offset = 0;
        int n = this.value.length;
        for (int index = 0; index < n; ++index) {
            this.value[index] = 0;
        }
    }

    private void reset() {
        this.intLen = 0;
        this.offset = 0;
    }

    private final int compare(RsaMutableBigInteger b) {
        if (b == null) {
            return 0;
        }
        int blen = b.intLen;
        if (this.intLen < blen) {
            return -1;
        }
        if (this.intLen > blen) {
            return 1;
        }
        int[] bval = b.value;
        int i = this.offset;
        int j = b.offset;
        while (i < this.intLen + this.offset) {
            int b2;
            int b1 = RsaMutableBigInteger.addSignedInts(this.value[i], Integer.MIN_VALUE);
            if (b1 < (b2 = RsaMutableBigInteger.addSignedInts(bval[j], Integer.MIN_VALUE))) {
                return -1;
            }
            if (b1 > b2) {
                return 1;
            }
            ++i;
            ++j;
        }
        return 0;
    }

    private int compareShifted(RsaMutableBigInteger b, int ints) {
        if (b == null) {
            return 0;
        }
        int alen = this.intLen - ints;
        int blen = b.intLen;
        if (alen < blen) {
            return -1;
        }
        if (alen > blen) {
            return 1;
        }
        int[] bval = b.value;
        int i = this.offset;
        int j = b.offset;
        while (i < alen + this.offset) {
            int b2;
            int b1 = RsaMutableBigInteger.addSignedInts(this.value[i], Integer.MIN_VALUE);
            if (b1 < (b2 = RsaMutableBigInteger.addSignedInts(bval[j], Integer.MIN_VALUE))) {
                return -1;
            }
            if (b1 > b2) {
                return 1;
            }
            ++i;
            ++j;
        }
        return 0;
    }

    private final int getLowestSetBit() {
        int j;
        if (this.intLen == 0) {
            return -1;
        }
        for (j = this.intLen - 1; j > 0 && this.value[j + this.offset] == 0; --j) {
        }
        int b = this.value[j + this.offset];
        if (b == 0) {
            return -1;
        }
        return (this.intLen - 1 - j << 5) + RsaMutableBigInteger.integerNumberOfTrailingZeros(b);
    }

    private final void normalize() {
        if (this.intLen == 0) {
            this.offset = 0;
            return;
        }
        int index = this.offset;
        if (this.value[index] != 0) {
            return;
        }
        int indexBound = index + this.intLen;
        ++index;
        while (index < indexBound && this.value[index] == 0) {
            ++index;
        }
        int numZeros = index - this.offset;
        this.intLen -= numZeros;
        this.offset = this.intLen == 0 ? 0 : this.offset + numZeros;
    }

    public int[] toIntArray() {
        int[] result = new int[this.intLen];
        for (int i = 0; i < this.intLen; ++i) {
            result[i] = this.value[this.offset + i];
        }
        return result;
    }

    private void setValue(int[] val, int length) {
        if (val == null || val.length <= 0) {
            val = new int[1];
        }
        this.value = val;
        this.intLen = length;
        this.offset = 0;
    }

    private void copyValue(RsaMutableBigInteger src) {
        if (src == null) {
            return;
        }
        int len = src.intLen;
        if (this.value.length < len) {
            this.value = new int[len];
        }
        System.arraycopy(src.value, src.offset, this.value, 0, len);
        this.intLen = len;
        this.offset = 0;
    }

    private boolean isOne() {
        return this.intLen == 1 && this.value[this.offset] == 1;
    }

    public boolean isZero() {
        return this.intLen == 0;
    }

    private boolean isEven() {
        return this.intLen == 0 || (this.value[this.offset + this.intLen - 1] & 1) == 0;
    }

    private boolean isOdd() {
        return !this.isZero() && (this.value[this.offset + this.intLen - 1] & 1) == 1;
    }

    private void safeRightShift(int n) {
        if (n / 32 >= this.intLen) {
            this.reset();
        } else {
            this.rightShift(n);
        }
    }

    private void rightShift(int n) {
        if (this.intLen == 0) {
            return;
        }
        int nInts = RsaMutableBigInteger.si(n, 5);
        int nBits = n & 0x1F;
        this.intLen -= nInts;
        if (nBits == 0) {
            return;
        }
        int bitsInHighWord = RsaMutableBigInteger.bitLengthForInt(this.value[this.offset]);
        if (nBits >= bitsInHighWord) {
            this.primitiveLeftShift(32 - nBits);
            --this.intLen;
        } else {
            this.primitiveRightShift(nBits);
        }
    }

    private void safeLeftShift(int n) {
        if (n > 0) {
            this.leftShift(n);
        }
    }

    public void leftShift(int n) {
        if (this.intLen == 0) {
            return;
        }
        int nInts = RsaMutableBigInteger.si(n, 5);
        int nBits = n & 0x1F;
        int bitsInHighWord = RsaMutableBigInteger.bitLengthForInt(this.value[this.offset]);
        if (n <= 32 - bitsInHighWord) {
            this.primitiveLeftShift(nBits);
            return;
        }
        int newLen = this.intLen + nInts + 1;
        if (nBits <= 32 - bitsInHighWord) {
            --newLen;
        }
        if (this.value.length < newLen) {
            int[] result = new int[newLen];
            for (int i = 0; i < this.intLen; ++i) {
                result[i] = this.value[this.offset + i];
            }
            this.setValue(result, newLen);
        } else if (this.value.length - this.offset >= newLen) {
            for (int i = 0; i < newLen - this.intLen; ++i) {
                this.value[this.offset + this.intLen + i] = 0;
            }
        } else {
            int i;
            for (i = 0; i < this.intLen; ++i) {
                this.value[i] = this.value[this.offset + i];
            }
            for (i = this.intLen; i < newLen; ++i) {
                this.value[i] = 0;
            }
            this.offset = 0;
        }
        this.intLen = newLen;
        if (nBits == 0) {
            return;
        }
        if (nBits <= 32 - bitsInHighWord) {
            this.primitiveLeftShift(nBits);
        } else {
            this.primitiveRightShift(32 - nBits);
        }
    }

    private int divadd(int[] a, int[] result, int offset) {
        if (a == null || result == null) {
            return 0;
        }
        long carry = 0L;
        for (int j = a.length - 1; j >= 0; --j) {
            long sum = ((long)a[j] & 0xFFFFFFFFL) + ((long)result[j + offset] & 0xFFFFFFFFL) + carry;
            result[j + offset] = (int)sum;
            carry = RsaMutableBigInteger.sl(sum, 32);
        }
        return (int)carry;
    }

    private int mulsub(int[] q, int[] a, int x, int len, int offset) {
        if (q == null || a == null) {
            return 0;
        }
        long xLong = (long)x & 0xFFFFFFFFL;
        long carry = 0L;
        offset += len;
        for (int j = len - 1; j >= 0; --j) {
            long product = ((long)a[j] & 0xFFFFFFFFL) * xLong + carry;
            long difference = (long)q[offset] - product;
            q[offset] = (int)difference;
            --offset;
            carry = RsaMutableBigInteger.sl(product, 32) + (long)((difference & 0xFFFFFFFFL) > ((long)(~((int)product)) & 0xFFFFFFFFL) ? 1 : 0);
        }
        return (int)carry;
    }

    private int mulsubBorrow(int[] q, int[] a, int x, int len, int offset) {
        if (q == null || a == null) {
            return 0;
        }
        long xLong = (long)x & 0xFFFFFFFFL;
        long carry = 0L;
        offset += len;
        for (int j = len - 1; j >= 0; --j) {
            long product = ((long)a[j] & 0xFFFFFFFFL) * xLong + carry;
            long difference = (long)q[offset] - product;
            --offset;
            carry = RsaMutableBigInteger.sl(product, 32) + (long)((difference & 0xFFFFFFFFL) > ((long)(~((int)product)) & 0xFFFFFFFFL) ? 1 : 0);
        }
        return (int)carry;
    }

    private final void primitiveRightShift(int n) {
        int i;
        int n2 = 32 - n;
        int c = this.value[i];
        for (i = this.offset + this.intLen - 1; i > this.offset; --i) {
            int b = c;
            c = this.value[i - 1];
            this.value[i] = c << n2 | RsaMutableBigInteger.si(b, n);
        }
        this.value[this.offset] = RsaMutableBigInteger.si(this.value[this.offset], n);
    }

    private final void primitiveLeftShift(int n) {
        int i;
        int n2 = 32 - n;
        int c = this.value[i];
        int m = i + this.intLen - 1;
        for (i = this.offset; i < m; ++i) {
            int b = c;
            c = this.value[i + 1];
            this.value[i] = b << n | RsaMutableBigInteger.si(c, n2);
        }
        int n3 = this.offset + this.intLen - 1;
        this.value[n3] = this.value[n3] << n;
    }

    private RsaBigInteger getLower(int n) {
        int len;
        if (this.isZero()) {
            return RsaBigInteger.ZERO;
        }
        if (this.intLen < n) {
            return this.toBigInteger(1);
        }
        for (len = n; len > 0 && this.value[this.offset + this.intLen - len] == 0; --len) {
        }
        int sign = len > 0 ? 1 : 0;
        return new RsaBigInteger(Arrays.copyOfRange(this.value, this.offset + this.intLen - len, this.offset + this.intLen), sign);
    }

    private void keepLower(int n) {
        if (this.intLen >= n) {
            this.offset += this.intLen - n;
            this.intLen = n;
        }
    }

    public void add(RsaMutableBigInteger addend) {
        long sum;
        if (addend == null) {
            return;
        }
        int x = this.intLen;
        int y = addend.intLen;
        int resultLen = this.intLen > addend.intLen ? this.intLen : addend.intLen;
        int[] result = this.value.length < resultLen ? new int[resultLen] : this.value;
        int rstart = result.length - 1;
        long carry = 0L;
        while (x > 0 && y > 0) {
            sum = ((long)this.value[--x + this.offset] & 0xFFFFFFFFL) + ((long)addend.value[--y + addend.offset] & 0xFFFFFFFFL) + carry;
            result[rstart] = (int)sum;
            --rstart;
            carry = RsaMutableBigInteger.sl(sum, 32);
        }
        while (x > 0) {
            if (carry == 0L && result == this.value && rstart == --x + this.offset) {
                return;
            }
            sum = ((long)this.value[x + this.offset] & 0xFFFFFFFFL) + carry;
            result[rstart] = (int)sum;
            --rstart;
            carry = RsaMutableBigInteger.sl(sum, 32);
        }
        while (y > 0) {
            sum = ((long)addend.value[--y + addend.offset] & 0xFFFFFFFFL) + carry;
            result[rstart] = (int)sum;
            --rstart;
            carry = RsaMutableBigInteger.sl(sum, 32);
        }
        if (carry > 0L) {
            if (result.length < ++resultLen) {
                int[] temp = new int[resultLen];
                System.arraycopy(result, 0, temp, 1, result.length);
                temp[0] = 1;
                result = temp;
            } else {
                result[rstart] = 1;
            }
        }
        this.value = result;
        this.intLen = resultLen;
        this.offset = result.length - resultLen;
    }

    private void addShifted(RsaMutableBigInteger addend, int n) {
        long sum;
        int bval;
        if (addend == null) {
            return;
        }
        if (addend.isZero()) {
            return;
        }
        int x = this.intLen;
        int y = addend.intLen + n;
        int resultLen = this.intLen > y ? this.intLen : y;
        int[] result = this.value.length < resultLen ? new int[resultLen] : this.value;
        int rstart = result.length - 1;
        long carry = 0L;
        while (x > 0 && y > 0) {
            bval = --y + addend.offset < addend.value.length ? addend.value[y + addend.offset] : 0;
            sum = ((long)this.value[--x + this.offset] & 0xFFFFFFFFL) + ((long)bval & 0xFFFFFFFFL) + carry;
            result[rstart] = (int)sum;
            --rstart;
            carry = RsaMutableBigInteger.sl(sum, 32);
        }
        while (x > 0) {
            if (carry == 0L && result == this.value && rstart == --x + this.offset) {
                return;
            }
            sum = ((long)this.value[x + this.offset] & 0xFFFFFFFFL) + carry;
            result[rstart] = (int)sum;
            --rstart;
            carry = RsaMutableBigInteger.sl(sum, 32);
        }
        while (y > 0) {
            bval = --y + addend.offset < addend.value.length ? addend.value[y + addend.offset] : 0;
            sum = ((long)bval & 0xFFFFFFFFL) + carry;
            result[rstart] = (int)sum;
            --rstart;
            carry = RsaMutableBigInteger.sl(sum, 32);
        }
        if (carry > 0L) {
            if (result.length < ++resultLen) {
                int[] temp = new int[resultLen];
                System.arraycopy(result, 0, temp, 1, result.length);
                temp[0] = 1;
                result = temp;
            } else {
                result[rstart] = 1;
            }
        }
        this.value = result;
        this.intLen = resultLen;
        this.offset = result.length - resultLen;
    }

    private void addDisjoint(RsaMutableBigInteger addend, int n) {
        int[] result;
        int resultLen;
        if (addend == null) {
            return;
        }
        if (addend.isZero()) {
            return;
        }
        int x = this.intLen;
        int y = addend.intLen + n;
        int n2 = resultLen = this.intLen > y ? this.intLen : y;
        if (this.value.length < resultLen) {
            result = new int[resultLen];
        } else {
            result = this.value;
            Arrays.fill(this.value, this.offset + this.intLen, this.value.length, 0);
        }
        int rstart = result.length - 1;
        System.arraycopy(this.value, this.offset, result, rstart + 1 - x, x);
        int len = Math.min(y -= x, addend.value.length - addend.offset);
        System.arraycopy(addend.value, addend.offset, result, (rstart -= x) + 1 - y, len);
        for (int i = rstart + 1 - y + len; i < rstart + 1; ++i) {
            result[i] = 0;
        }
        this.value = result;
        this.intLen = resultLen;
        this.offset = result.length - resultLen;
    }

    private void addLower(RsaMutableBigInteger addend, int n) {
        if (addend == null) {
            return;
        }
        RsaMutableBigInteger a = new RsaMutableBigInteger(addend);
        if (a.offset + a.intLen >= n) {
            a.offset = a.offset + a.intLen - n;
            a.intLen = n;
        }
        a.normalize();
        this.add(a);
    }

    public int subtract(RsaMutableBigInteger b) {
        int resultLen;
        if (b == null) {
            return 0;
        }
        RsaMutableBigInteger a = this;
        int[] result = this.value;
        int sign = a.compare(b);
        if (sign == 0) {
            this.reset();
            return 0;
        }
        if (sign < 0) {
            RsaMutableBigInteger tmp = a;
            a = b;
            b = tmp;
        }
        if (result.length < (resultLen = a.intLen)) {
            result = new int[resultLen];
        }
        long diff = 0L;
        int x = a.intLen;
        int y = b.intLen;
        int rstart = result.length - 1;
        while (y > 0) {
            diff = ((long)a.value[--x + a.offset] & 0xFFFFFFFFL) - ((long)b.value[--y + b.offset] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            result[rstart] = (int)diff;
            --rstart;
        }
        while (x > 0) {
            diff = ((long)a.value[--x + a.offset] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            result[rstart] = (int)diff;
            --rstart;
        }
        this.value = result;
        this.intLen = resultLen;
        this.offset = this.value.length - resultLen;
        this.normalize();
        return sign;
    }

    private int difference(RsaMutableBigInteger b) {
        if (b == null) {
            return 0;
        }
        RsaMutableBigInteger a = this;
        int sign = a.compare(b);
        if (sign == 0) {
            return 0;
        }
        if (sign < 0) {
            RsaMutableBigInteger tmp = a;
            a = b;
            b = tmp;
        }
        long diff = 0L;
        int x = a.intLen;
        int y = b.intLen;
        while (y > 0) {
            diff = ((long)a.value[a.offset + --x] & 0xFFFFFFFFL) - ((long)b.value[b.offset + --y] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            a.value[a.offset + x] = (int)diff;
        }
        while (x > 0) {
            diff = ((long)a.value[a.offset + --x] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            a.value[a.offset + x] = (int)diff;
        }
        a.normalize();
        return sign;
    }

    public void multiply(RsaMutableBigInteger y, RsaMutableBigInteger z) {
        if (y == null || z == null) {
            return;
        }
        int xLen = this.intLen;
        int yLen = y.intLen;
        int newLen = xLen + yLen;
        if (z.value.length < newLen) {
            z.value = new int[newLen];
        }
        z.offset = 0;
        z.intLen = newLen;
        long carry = 0L;
        int j = yLen - 1;
        int k = yLen + xLen - 1;
        while (j >= 0) {
            long product = ((long)y.value[j + y.offset] & 0xFFFFFFFFL) * ((long)this.value[xLen - 1 + this.offset] & 0xFFFFFFFFL) + carry;
            z.value[k] = (int)product;
            carry = RsaMutableBigInteger.sl(product, 32);
            --j;
            --k;
        }
        z.value[xLen - 1] = (int)carry;
        for (int i = xLen - 2; i >= 0; --i) {
            carry = 0L;
            int j2 = yLen - 1;
            int k2 = yLen + i;
            while (j2 >= 0) {
                long product = ((long)y.value[j2 + y.offset] & 0xFFFFFFFFL) * ((long)this.value[i + this.offset] & 0xFFFFFFFFL) + ((long)z.value[k2] & 0xFFFFFFFFL) + carry;
                z.value[k2] = (int)product;
                carry = RsaMutableBigInteger.sl(product, 32);
                --j2;
                --k2;
            }
            z.value[i] = (int)carry;
        }
        z.normalize();
    }

    private void mul(int y, RsaMutableBigInteger z) {
        if (z == null) {
            return;
        }
        if (y == 1) {
            z.copyValue(this);
            return;
        }
        if (y == 0) {
            z.clear();
            return;
        }
        long ylong = (long)y & 0xFFFFFFFFL;
        int[] zval = z.value.length < this.intLen + 1 ? new int[this.intLen + 1] : z.value;
        long carry = 0L;
        for (int i = this.intLen - 1; i >= 0; --i) {
            long product = ylong * ((long)this.value[i + this.offset] & 0xFFFFFFFFL) + carry;
            zval[i + 1] = (int)product;
            carry = RsaMutableBigInteger.sl(product, 32);
        }
        if (carry == 0L) {
            z.offset = 1;
            z.intLen = this.intLen;
        } else {
            z.offset = 0;
            z.intLen = this.intLen + 1;
            zval[0] = (int)carry;
        }
        z.value = zval;
    }

    public static int bitLengthForInt(int n) {
        return 32 - RsaMutableBigInteger.integerNumberOfLeadingZeros(n);
    }

    private static int integerNumberOfTrailingZeros(int i) {
        if (i == 0) {
            return 32;
        }
        int n = 31;
        int y = i << 16;
        if (y != 0) {
            n -= 16;
            i = y;
        }
        if ((y = i << 8) != 0) {
            n -= 8;
            i = y;
        }
        if ((y = i << 4) != 0) {
            n -= 4;
            i = y;
        }
        if ((y = i << 2) != 0) {
            n -= 2;
            i = y;
        }
        return n - RsaMutableBigInteger.si(i << 1, 31);
    }

    private static int integerNumberOfLeadingZeros(int i) {
        if (i == 0) {
            return 32;
        }
        int n = 1;
        if (RsaMutableBigInteger.si(i, 16) == 0) {
            n += 16;
            i <<= 16;
        }
        if (RsaMutableBigInteger.si(i, 24) == 0) {
            n += 8;
            i <<= 8;
        }
        if (RsaMutableBigInteger.si(i, 28) == 0) {
            n += 4;
            i <<= 4;
        }
        if (RsaMutableBigInteger.si(i, 30) == 0) {
            n += 2;
            i <<= 2;
        }
        return n -= RsaMutableBigInteger.si(i, 31);
    }

    public int divideOneWord(int divisor, RsaMutableBigInteger quotient) {
        if (quotient == null) {
            return 0;
        }
        long divisorLong = (long)divisor & 0xFFFFFFFFL;
        if (this.intLen == 1) {
            long dividendValue = (long)this.value[this.offset] & 0xFFFFFFFFL;
            int q = (int)(dividendValue / divisorLong);
            int r = (int)(dividendValue - (long)q * divisorLong);
            quotient.value[0] = q;
            quotient.intLen = q == 0 ? 0 : 1;
            quotient.offset = 0;
            return r;
        }
        if (quotient.value.length < this.intLen) {
            quotient.value = new int[this.intLen];
        }
        quotient.offset = 0;
        quotient.intLen = this.intLen;
        int shift = RsaMutableBigInteger.integerNumberOfLeadingZeros(divisor);
        int rem = this.value[this.offset];
        long remLong = (long)rem & 0xFFFFFFFFL;
        if (remLong < divisorLong) {
            quotient.value[0] = 0;
        } else {
            quotient.value[0] = (int)(remLong / divisorLong);
            rem = (int)(remLong - (long)quotient.value[0] * divisorLong);
            remLong = (long)rem & 0xFFFFFFFFL;
        }
        int xlen = this.intLen;
        --xlen;
        while (xlen > 0) {
            int q;
            long dividendEstimate = remLong << 32 | (long)this.value[this.offset + this.intLen - xlen] & 0xFFFFFFFFL;
            if (dividendEstimate >= 0L) {
                q = (int)(dividendEstimate / divisorLong);
                rem = (int)(dividendEstimate - (long)q * divisorLong);
            } else {
                long tmp = RsaMutableBigInteger.divWord(dividendEstimate, divisor);
                q = (int)(tmp & 0xFFFFFFFFL);
                rem = (int)RsaMutableBigInteger.sl(tmp, 32);
            }
            quotient.value[this.intLen - xlen] = q;
            remLong = (long)rem & 0xFFFFFFFFL;
            --xlen;
        }
        quotient.normalize();
        if (shift > 0) {
            return rem % divisor;
        }
        return rem;
    }

    public RsaMutableBigInteger divide(RsaMutableBigInteger b, RsaMutableBigInteger quotient) {
        if (b == null || quotient == null) {
            return null;
        }
        return this.divide(b, quotient, true);
    }

    private RsaMutableBigInteger divide(RsaMutableBigInteger b, RsaMutableBigInteger quotient, boolean needRemainder) {
        if (b == null || quotient == null) {
            return null;
        }
        if (b.intLen < 80 || this.intLen - b.intLen < 40) {
            return this.divideKnuth(b, quotient, needRemainder);
        }
        return this.divideAndRemainderBurnikelZiegler(b, quotient);
    }

    public RsaMutableBigInteger divideKnuth(RsaMutableBigInteger b, RsaMutableBigInteger quotient) {
        if (b == null || quotient == null) {
            return null;
        }
        return this.divideKnuth(b, quotient, true);
    }

    private RsaMutableBigInteger divideKnuth(RsaMutableBigInteger b, RsaMutableBigInteger quotient, boolean needRemainder) {
        int trailingZeroBits;
        if (b == null || quotient == null) {
            return null;
        }
        if (b.intLen == 0) {
            return null;
        }
        if (this.intLen == 0) {
            quotient.intLen = 0;
            quotient.offset = 0;
            return needRemainder ? new RsaMutableBigInteger() : null;
        }
        int cmp = this.compare(b);
        if (cmp < 0) {
            quotient.intLen = 0;
            quotient.offset = 0;
            return needRemainder ? new RsaMutableBigInteger(this) : null;
        }
        if (cmp == 0) {
            quotient.value[0] = 1;
            quotient.intLen = 1;
            quotient.offset = 0;
            return needRemainder ? new RsaMutableBigInteger() : null;
        }
        quotient.clear();
        if (b.intLen == 1) {
            int r = this.divideOneWord(b.value[b.offset], quotient);
            if (needRemainder) {
                if (r == 0) {
                    return new RsaMutableBigInteger();
                }
                return new RsaMutableBigInteger(r);
            }
            return null;
        }
        if (this.intLen >= 6 && (trailingZeroBits = Math.min(this.getLowestSetBit(), b.getLowestSetBit())) >= 96) {
            RsaMutableBigInteger a = new RsaMutableBigInteger(this);
            b = new RsaMutableBigInteger(b);
            a.rightShift(trailingZeroBits);
            b.rightShift(trailingZeroBits);
            RsaMutableBigInteger r = a.divideKnuth(b, quotient);
            if (r == null) {
                return null;
            }
            r.leftShift(trailingZeroBits);
            return r;
        }
        return this.divideMagnitude(b, quotient, needRemainder);
    }

    public RsaMutableBigInteger divideAndRemainderBurnikelZiegler(RsaMutableBigInteger b, RsaMutableBigInteger quotient) {
        RsaMutableBigInteger ri;
        if (b == null || quotient == null) {
            return null;
        }
        int r = this.intLen;
        int s = b.intLen;
        quotient.intLen = 0;
        quotient.offset = 0;
        if (r < s) {
            return this;
        }
        int m = 1 << 32 - RsaMutableBigInteger.integerNumberOfLeadingZeros(s / 80);
        int j = (s + m - 1) / m;
        int n = j * m;
        long n32 = 32L * (long)n;
        int sigma = (int)Math.max(0L, n32 - b.bitLength());
        RsaMutableBigInteger bShifted = new RsaMutableBigInteger(b);
        bShifted.safeLeftShift(sigma);
        RsaMutableBigInteger aShifted = new RsaMutableBigInteger(this);
        aShifted.safeLeftShift(sigma);
        int t = (int)((aShifted.bitLength() + n32) / n32);
        if (t < 2) {
            t = 2;
        }
        RsaMutableBigInteger a1 = aShifted.getBlock(t - 1, t, n);
        RsaMutableBigInteger z = aShifted.getBlock(t - 2, t, n);
        z.addDisjoint(a1, n);
        RsaMutableBigInteger qi = new RsaMutableBigInteger();
        for (int i = t - 2; i > 0; --i) {
            ri = z.divide2n1n(bShifted, qi);
            if (ri == null) {
                return null;
            }
            z = aShifted.getBlock(i - 1, t, n);
            z.addDisjoint(ri, n);
            quotient.addShifted(qi, i * n);
        }
        ri = z.divide2n1n(bShifted, qi);
        if (ri == null) {
            return null;
        }
        quotient.add(qi);
        ri.rightShift(sigma);
        return ri;
    }

    private RsaMutableBigInteger divide2n1n(RsaMutableBigInteger b, RsaMutableBigInteger quotient) {
        if (b == null || quotient == null) {
            return null;
        }
        int n = b.intLen;
        if (n % 2 != 0 || n < 80) {
            return this.divideKnuth(b, quotient);
        }
        RsaMutableBigInteger aUpper = new RsaMutableBigInteger(this);
        aUpper.safeRightShift(32 * (n / 2));
        this.keepLower(n / 2);
        RsaMutableBigInteger q1 = new RsaMutableBigInteger();
        RsaMutableBigInteger r1 = aUpper.divide3n2n(b, q1);
        if (r1 == null) {
            return null;
        }
        this.addDisjoint(r1, n / 2);
        RsaMutableBigInteger r2 = this.divide3n2n(b, quotient);
        if (r2 == null) {
            return null;
        }
        quotient.addDisjoint(q1, n / 2);
        return r2;
    }

    private RsaMutableBigInteger divide3n2n(RsaMutableBigInteger b, RsaMutableBigInteger quotient) {
        RsaMutableBigInteger d;
        RsaMutableBigInteger r;
        if (b == null || quotient == null) {
            return null;
        }
        int n = b.intLen / 2;
        RsaMutableBigInteger a12 = new RsaMutableBigInteger(this);
        a12.safeRightShift(32 * n);
        RsaMutableBigInteger b1 = new RsaMutableBigInteger(b);
        b1.safeRightShift(n * 32);
        RsaBigInteger b2 = b.getLower(n);
        if (b2 == null) {
            return null;
        }
        if (this.compareShifted(b, n) < 0) {
            r = a12.divide2n1n(b1, quotient);
            if (r == null) {
                return null;
            }
            RsaBigInteger qbigint = quotient.toBigInteger();
            if (qbigint == null) {
                return null;
            }
            if ((qbigint = qbigint.multiply(b2)) == null) {
                return null;
            }
            d = new RsaMutableBigInteger(qbigint);
        } else {
            quotient.ones(n);
            a12.add(b1);
            b1.leftShift(32 * n);
            a12.subtract(b1);
            r = a12;
            d = new RsaMutableBigInteger(b2);
            d.leftShift(32 * n);
            d.subtract(new RsaMutableBigInteger(b2));
        }
        r.leftShift(32 * n);
        r.addLower(this, n);
        while (r.compare(d) < 0) {
            r.add(b);
            quotient.subtract(ONE);
        }
        r.subtract(d);
        return r;
    }

    private RsaMutableBigInteger getBlock(int index, int numBlocks, int blockLength) {
        int blockStart = index * blockLength;
        if (blockStart >= this.intLen) {
            return new RsaMutableBigInteger();
        }
        int blockEnd = index == numBlocks - 1 ? this.intLen : (index + 1) * blockLength;
        if (blockEnd > this.intLen) {
            return new RsaMutableBigInteger();
        }
        int[] newVal = Arrays.copyOfRange(this.value, this.offset + this.intLen - blockEnd, this.offset + this.intLen - blockStart);
        return new RsaMutableBigInteger(newVal);
    }

    private long bitLength() {
        if (this.intLen == 0) {
            return 0L;
        }
        return (long)this.intLen * 32L - (long)RsaMutableBigInteger.integerNumberOfLeadingZeros(this.value[this.offset]);
    }

    private static void copyAndShift(int[] src, int srcFrom, int srcLen, int[] dst, int dstFrom, int shift) {
        if (src == null || dst == null) {
            return;
        }
        int n2 = 32 - shift;
        int c = src[srcFrom];
        for (int i = 0; i < srcLen - 1; ++i) {
            int b = c;
            c = src[++srcFrom];
            dst[dstFrom + i] = b << shift | RsaMutableBigInteger.si(c, n2);
        }
        dst[dstFrom + srcLen - 1] = c << shift;
    }

    private RsaMutableBigInteger divideMagnitude(RsaMutableBigInteger div, RsaMutableBigInteger quotient, boolean needRemainder) {
        int qrem;
        int qhat;
        RsaMutableBigInteger rem;
        int[] divisor;
        if (div == null || quotient == null) {
            return null;
        }
        int shift = RsaMutableBigInteger.integerNumberOfLeadingZeros(div.value[div.offset]);
        int dlen = div.intLen;
        if (shift > 0) {
            int[] remarr;
            divisor = new int[dlen];
            RsaMutableBigInteger.copyAndShift(div.value, div.offset, dlen, divisor, 0, shift);
            if (RsaMutableBigInteger.integerNumberOfLeadingZeros(this.value[this.offset]) >= shift) {
                remarr = new int[this.intLen + 1];
                RsaMutableBigInteger.copyAndShift(this.value, this.offset, this.intLen, remarr, 1, shift);
                rem = new RsaMutableBigInteger(remarr);
                rem.intLen = this.intLen;
                rem.offset = 1;
            } else {
                remarr = new int[this.intLen + 2];
                int rFrom = this.offset;
                int c = 0;
                int n2 = 32 - shift;
                int i = 1;
                while (i < this.intLen + 1) {
                    int b = c;
                    c = this.value[rFrom];
                    remarr[i] = b << shift | RsaMutableBigInteger.si(c, n2);
                    ++i;
                    ++rFrom;
                }
                remarr[this.intLen + 1] = c << shift;
                rem = new RsaMutableBigInteger(remarr);
                rem.intLen = this.intLen + 1;
                rem.offset = 1;
            }
        } else {
            divisor = Arrays.copyOfRange(div.value, div.offset, div.offset + div.intLen);
            rem = new RsaMutableBigInteger(new int[this.intLen + 1]);
            System.arraycopy(this.value, this.offset, rem.value, 1, this.intLen);
            rem.intLen = this.intLen;
            rem.offset = 1;
        }
        int nlen = rem.intLen;
        int limit = nlen - dlen + 1;
        if (quotient.value.length < limit) {
            quotient.value = new int[limit];
            quotient.offset = 0;
        }
        quotient.intLen = limit;
        int[] q = quotient.value;
        rem.offset = 0;
        rem.value[0] = 0;
        ++rem.intLen;
        int dh = divisor[0];
        long dhLong = (long)dh & 0xFFFFFFFFL;
        int dl = divisor[1];
        for (int j = 0; j < limit - 1; ++j) {
            long nl;
            long rs;
            long estProduct;
            int qrem2;
            int qhat2;
            boolean skipCorrection = false;
            int nh = rem.value[j + rem.offset];
            int nh2 = RsaMutableBigInteger.addSignedInts(nh, Integer.MIN_VALUE);
            int nm = rem.value[j + 1 + rem.offset];
            if (nh == dh) {
                qhat2 = -1;
                qrem2 = nh + nm;
                skipCorrection = RsaMutableBigInteger.addSignedInts(qrem2, Integer.MIN_VALUE) < nh2;
            } else {
                long nChunk = (long)nh << 32 | (long)nm & 0xFFFFFFFFL;
                if (nChunk >= 0L) {
                    qhat2 = (int)(nChunk / dhLong);
                    qrem2 = (int)(nChunk - (long)qhat2 * dhLong);
                } else {
                    long tmp = RsaMutableBigInteger.divWord(nChunk, dh);
                    qhat2 = (int)(tmp & 0xFFFFFFFFL);
                    qrem2 = (int)RsaMutableBigInteger.sl(tmp, 32);
                }
            }
            if (qhat2 == 0) continue;
            if (!skipCorrection && RsaMutableBigInteger.unsignedLongCompare(estProduct = ((long)dl & 0xFFFFFFFFL) * ((long)qhat2 & 0xFFFFFFFFL), rs = ((long)qrem2 & 0xFFFFFFFFL) << 32 | (nl = (long)rem.value[j + 2 + rem.offset] & 0xFFFFFFFFL))) {
                --qhat2;
                if (((long)(qrem2 = (int)(((long)qrem2 & 0xFFFFFFFFL) + dhLong)) & 0xFFFFFFFFL) >= dhLong && RsaMutableBigInteger.unsignedLongCompare(estProduct -= (long)dl & 0xFFFFFFFFL, rs = ((long)qrem2 & 0xFFFFFFFFL) << 32 | nl)) {
                    --qhat2;
                }
            }
            rem.value[j + rem.offset] = 0;
            int borrow = this.mulsub(rem.value, divisor, qhat2, dlen, j + rem.offset);
            if (RsaMutableBigInteger.addSignedInts(borrow, Integer.MIN_VALUE) > nh2) {
                this.divadd(divisor, rem.value, j + 1 + rem.offset);
            }
            q[j] = --qhat2;
        }
        boolean skipCorrection = false;
        int nh = rem.value[limit - 1 + rem.offset];
        int nh2 = RsaMutableBigInteger.addSignedInts(nh, Integer.MIN_VALUE);
        int nm = rem.value[limit + rem.offset];
        if (nh == dh) {
            qhat = -1;
            qrem = nh + nm;
            skipCorrection = RsaMutableBigInteger.addSignedInts(qrem, Integer.MIN_VALUE) < nh2;
        } else {
            long nChunk = (long)nh << 32 | (long)nm & 0xFFFFFFFFL;
            if (nChunk >= 0L) {
                qhat = (int)(nChunk / dhLong);
                qrem = (int)(nChunk - (long)qhat * dhLong);
            } else {
                long tmp = RsaMutableBigInteger.divWord(nChunk, dh);
                qhat = (int)(tmp & 0xFFFFFFFFL);
                qrem = (int)RsaMutableBigInteger.sl(tmp, 32);
            }
        }
        if (qhat != 0) {
            long nl;
            long rs;
            long estProduct;
            if (!skipCorrection && RsaMutableBigInteger.unsignedLongCompare(estProduct = ((long)dl & 0xFFFFFFFFL) * ((long)qhat & 0xFFFFFFFFL), rs = ((long)qrem & 0xFFFFFFFFL) << 32 | (nl = (long)rem.value[limit + 1 + rem.offset] & 0xFFFFFFFFL))) {
                --qhat;
                if (((long)(qrem = (int)(((long)qrem & 0xFFFFFFFFL) + dhLong)) & 0xFFFFFFFFL) >= dhLong && RsaMutableBigInteger.unsignedLongCompare(estProduct -= (long)dl & 0xFFFFFFFFL, rs = ((long)qrem & 0xFFFFFFFFL) << 32 | nl)) {
                    --qhat;
                }
            }
            rem.value[limit - 1 + rem.offset] = 0;
            int borrow = needRemainder ? this.mulsub(rem.value, divisor, qhat, dlen, limit - 1 + rem.offset) : this.mulsubBorrow(rem.value, divisor, qhat, dlen, limit - 1 + rem.offset);
            if (RsaMutableBigInteger.addSignedInts(borrow, Integer.MIN_VALUE) > nh2 && needRemainder) {
                this.divadd(divisor, rem.value, limit - 1 + 1 + rem.offset);
            }
            q[limit - 1] = --qhat;
        }
        if (needRemainder) {
            if (shift > 0) {
                rem.rightShift(shift);
            }
            rem.normalize();
        }
        quotient.normalize();
        return needRemainder ? rem : null;
    }

    private static boolean unsignedLongCompare(long one, long two) {
        return one + Long.MIN_VALUE > two + Long.MIN_VALUE;
    }

    private static int addSignedInts(int one, int two) {
        return one + two;
    }

    private static long divWord(long n, int d) {
        long dLong = (long)d & 0xFFFFFFFFL;
        if (dLong == 1L) {
            long q = (int)n;
            long r = 0L;
            return r << 32 | q & 0xFFFFFFFFL;
        }
        long q = RsaMutableBigInteger.sl(n, 1) / RsaMutableBigInteger.sl(dLong, 1);
        long r = n - q * dLong;
        while (r < 0L) {
            r += dLong;
            --q;
        }
        while (r >= dLong) {
            r -= dLong;
            ++q;
        }
        return r << 32 | q & 0xFFFFFFFFL;
    }

    public RsaMutableBigInteger hybridGCD(RsaMutableBigInteger b) {
        if (b == null) {
            return null;
        }
        RsaMutableBigInteger a = this;
        RsaMutableBigInteger q = new RsaMutableBigInteger();
        while (b.intLen != 0) {
            if (Math.abs(a.intLen - b.intLen) < 2) {
                return a.binaryGCD(b);
            }
            RsaMutableBigInteger r = a.divide(b, q);
            if (r == null) {
                return null;
            }
            a = b;
            b = r;
        }
        return a;
    }

    private RsaMutableBigInteger binaryGCD(RsaMutableBigInteger v) {
        int s2;
        int k;
        if (v == null) {
            return null;
        }
        RsaMutableBigInteger u = this;
        RsaMutableBigInteger r = new RsaMutableBigInteger();
        int s1 = u.getLowestSetBit();
        int n = k = s1 < (s2 = v.getLowestSetBit()) ? s1 : s2;
        if (k != 0) {
            u.rightShift(k);
            v.rightShift(k);
        }
        boolean uOdd = k == s1;
        RsaMutableBigInteger t = uOdd ? v : u;
        int tsign = uOdd ? -1 : 1;
        int lb = t.getLowestSetBit();
        while (lb >= 0) {
            t.rightShift(lb);
            if (tsign > 0) {
                u = t;
            } else {
                v = t;
            }
            if (u.intLen < 2 && v.intLen < 2) {
                int x = u.value[u.offset];
                int y = v.value[v.offset];
                r.value[0] = x = RsaMutableBigInteger.binaryGcd(x, y);
                r.intLen = 1;
                r.offset = 0;
                if (k > 0) {
                    r.leftShift(k);
                }
                return r;
            }
            tsign = u.difference(v);
            if (tsign == 0) break;
            t = tsign >= 0 ? u : v;
            lb = t.getLowestSetBit();
        }
        if (k > 0) {
            u.leftShift(k);
        }
        return u;
    }

    private static int binaryGcd(int a, int b) {
        int t;
        if (b == 0) {
            return a;
        }
        if (a == 0) {
            return b;
        }
        int aZeros = RsaMutableBigInteger.integerNumberOfTrailingZeros(a);
        int bZeros = RsaMutableBigInteger.integerNumberOfTrailingZeros(b);
        a = RsaMutableBigInteger.si(a, aZeros);
        b = RsaMutableBigInteger.si(b, bZeros);
        int n = t = aZeros < bZeros ? aZeros : bZeros;
        while (a != b) {
            if (RsaMutableBigInteger.addSignedInts(a, Integer.MIN_VALUE) > RsaMutableBigInteger.addSignedInts(b, Integer.MIN_VALUE)) {
                a -= b;
                a = RsaMutableBigInteger.si(a, RsaMutableBigInteger.integerNumberOfTrailingZeros(a));
                continue;
            }
            b -= a;
            b = RsaMutableBigInteger.si(b, RsaMutableBigInteger.integerNumberOfTrailingZeros(b));
        }
        return a << t;
    }

    public RsaMutableBigInteger mutableModInverse(RsaMutableBigInteger p) {
        if (p == null) {
            return null;
        }
        if (p.isOdd()) {
            return this.modInverse(p);
        }
        if (this.isEven()) {
            return null;
        }
        int powersOf2 = p.getLowestSetBit();
        RsaMutableBigInteger oddMod = new RsaMutableBigInteger(p);
        oddMod.rightShift(powersOf2);
        if (oddMod.isOne()) {
            return this.modInverseMP2(powersOf2);
        }
        RsaMutableBigInteger oddPart = this.modInverse(oddMod);
        if (oddPart == null) {
            return null;
        }
        RsaMutableBigInteger evenPart = this.modInverseMP2(powersOf2);
        if (evenPart == null) {
            return null;
        }
        RsaMutableBigInteger y1 = RsaMutableBigInteger.modInverseBP2(oddMod, powersOf2);
        if (y1 == null) {
            return null;
        }
        RsaMutableBigInteger y2 = oddMod.modInverseMP2(powersOf2);
        if (y2 == null) {
            return null;
        }
        RsaMutableBigInteger temp1 = new RsaMutableBigInteger();
        RsaMutableBigInteger temp2 = new RsaMutableBigInteger();
        RsaMutableBigInteger result = new RsaMutableBigInteger();
        oddPart.leftShift(powersOf2);
        oddPart.multiply(y1, result);
        evenPart.multiply(oddMod, temp1);
        temp1.multiply(y2, temp2);
        result.add(temp2);
        return result.divide(p, temp1);
    }

    private RsaMutableBigInteger modInverseMP2(int k) {
        if (this.isEven()) {
            return null;
        }
        if (k > 64) {
            return this.euclidModInverse(k);
        }
        int t = RsaMutableBigInteger.inverseMod32(this.value[this.offset + this.intLen - 1]);
        if (k < 33) {
            t = k == 32 ? t : t & (1 << k) - 1;
            return new RsaMutableBigInteger(t);
        }
        long pLong = (long)this.value[this.offset + this.intLen - 1] & 0xFFFFFFFFL;
        if (this.intLen > 1) {
            pLong |= (long)this.value[this.offset + this.intLen - 2] << 32;
        }
        long tLong = (long)t & 0xFFFFFFFFL;
        tLong *= 2L - pLong * tLong;
        tLong = k == 64 ? tLong : tLong & (1L << k) - 1L;
        RsaMutableBigInteger result = new RsaMutableBigInteger(new int[2]);
        result.value[0] = (int)RsaMutableBigInteger.sl(tLong, 32);
        result.value[1] = (int)tLong;
        result.intLen = 2;
        result.normalize();
        return result;
    }

    public static int inverseMod32(int val) {
        int t = val;
        t *= 2 - val * t;
        t *= 2 - val * t;
        t *= 2 - val * t;
        t *= 2 - val * t;
        return t;
    }

    private static RsaMutableBigInteger modInverseBP2(RsaMutableBigInteger mod, int k) {
        if (mod == null) {
            return null;
        }
        return RsaMutableBigInteger.fixup(new RsaMutableBigInteger(1), new RsaMutableBigInteger(mod), k);
    }

    private RsaMutableBigInteger modInverse(RsaMutableBigInteger mod) {
        int trailingZeros;
        if (mod == null) {
            return null;
        }
        RsaMutableBigInteger p = new RsaMutableBigInteger(mod);
        RsaMutableBigInteger f = new RsaMutableBigInteger(this);
        RsaMutableBigInteger g = new RsaMutableBigInteger(p);
        RsaSignedMutableBigInteger c = new RsaSignedMutableBigInteger(1);
        RsaSignedMutableBigInteger d = new RsaSignedMutableBigInteger();
        int k = 0;
        if (f.isEven()) {
            trailingZeros = f.getLowestSetBit();
            f.rightShift(trailingZeros);
            d.leftShift(trailingZeros);
            k = trailingZeros;
        }
        while (!f.isOne()) {
            if (f.isZero()) {
                return null;
            }
            if (f.compare(g) < 0) {
                RsaMutableBigInteger temp = f;
                f = g;
                g = temp;
                RsaSignedMutableBigInteger sTemp = d;
                d = c;
                c = sTemp;
            }
            if (((f.value[f.offset + f.intLen - 1] ^ g.value[g.offset + g.intLen - 1]) & 3) == 0) {
                f.subtract(g);
                c.signedSubtract(d);
            } else {
                f.add(g);
                c.signedAdd(d);
            }
            trailingZeros = f.getLowestSetBit();
            f.rightShift(trailingZeros);
            d.leftShift(trailingZeros);
            k += trailingZeros;
        }
        while (c.sign < 0) {
            c.signedAdd(p);
        }
        return RsaMutableBigInteger.fixup(c, p, k);
    }

    private static RsaMutableBigInteger fixup(RsaMutableBigInteger c, RsaMutableBigInteger p, int k) {
        if (c == null || p == null) {
            return null;
        }
        RsaMutableBigInteger temp = new RsaMutableBigInteger();
        int r = -RsaMutableBigInteger.inverseMod32(p.value[p.offset + p.intLen - 1]);
        int numWords = k >> 5;
        for (int i = 0; i < numWords; ++i) {
            int v = r * c.value[c.offset + c.intLen - 1];
            p.mul(v, temp);
            c.add(temp);
            --c.intLen;
        }
        int numBits = k & 0x1F;
        if (numBits != 0) {
            int v = r * c.value[c.offset + c.intLen - 1];
            p.mul(v &= (1 << numBits) - 1, temp);
            c.add(temp);
            c.rightShift(numBits);
        }
        while (c.compare(p) >= 0) {
            c.subtract(p);
        }
        return c;
    }

    private RsaMutableBigInteger euclidModInverse(int k) {
        RsaMutableBigInteger b = new RsaMutableBigInteger(1);
        b.leftShift(k);
        RsaMutableBigInteger mod = new RsaMutableBigInteger(b);
        RsaMutableBigInteger a = new RsaMutableBigInteger(this);
        RsaMutableBigInteger q = new RsaMutableBigInteger();
        b = b.divide(a, q);
        RsaMutableBigInteger t1 = new RsaMutableBigInteger(q);
        RsaMutableBigInteger t0 = new RsaMutableBigInteger(1);
        RsaMutableBigInteger temp = new RsaMutableBigInteger();
        while (!b.isOne()) {
            RsaMutableBigInteger r = a.divide(b, q);
            if (r == null) {
                return null;
            }
            if (r.intLen == 0) {
                return null;
            }
            a = r;
            if (q.intLen == 1) {
                t1.mul(q.value[q.offset], temp);
            } else {
                q.multiply(t1, temp);
            }
            RsaMutableBigInteger swapper = q;
            q = temp;
            temp = swapper;
            t0.add(q);
            if (a.isOne()) {
                return t0;
            }
            r = b.divide(a, q);
            if (r == null) {
                return null;
            }
            if (r.intLen == 0) {
                return null;
            }
            b = r;
            if (q.intLen == 1) {
                t0.mul(q.value[q.offset], temp);
            } else {
                q.multiply(t0, temp);
            }
            swapper = q;
            q = temp;
            temp = swapper;
            t1.add(q);
        }
        mod.subtract(t1);
        return mod;
    }
}

