/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.internal;

public class HashingSha256 {
    private static final int[] k = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private static final int BLOCK_SIZE = 64;
    private int[] w = null;
    private int h0 = 1779033703;
    private int h1 = -1150833019;
    private int h2 = 1013904242;
    private int h3 = -1521486534;
    private int h4 = 1359893119;
    private int h5 = -1694144372;
    private int h6 = 528734635;
    private int h7 = 1541459225;
    private int count = 0;
    private byte[] buffer = null;

    private void initialize() {
        this.w = new int[64];
        this.buffer = new byte[64];
    }

    private void update(byte[] b, int offset, int len) {
        int n = this.count % 64;
        this.count += len;
        int partLen = 64 - n;
        int i = 0;
        if (len >= partLen) {
            System.arraycopy(b, offset, this.buffer, n, partLen);
            this.sha(this.buffer, 0);
            i = partLen;
            while (i + 64 - 1 < len) {
                this.sha(b, offset + i);
                i += 64;
            }
            n = 0;
        }
        if (i < len) {
            System.arraycopy(b, offset + i, this.buffer, n, len - i);
        }
    }

    private byte[] digest() {
        byte[] tail = this.padBuffer();
        this.update(tail, 0, tail.length);
        return this.getResult();
    }

    private byte[] padBuffer() {
        int n = this.count % 64;
        int padding = n < 56 ? 56 - n : 120 - n;
        byte[] result = new byte[padding + 8];
        result[0] = -128;
        long bits = this.count << 3;
        result[padding] = (byte)(bits >> 56);
        result[padding + 1] = (byte)(bits >> 48);
        result[padding + 2] = (byte)(bits >> 40);
        result[padding + 3] = (byte)(bits >> 32);
        result[padding + 4] = (byte)(bits >> 24);
        result[padding + 5] = (byte)(bits >> 16);
        result[padding + 6] = (byte)(bits >> 8);
        result[padding + 7] = (byte)bits;
        return result;
    }

    private byte[] getResult() {
        return new byte[]{(byte)(this.h0 >> 24), (byte)(this.h0 >> 16), (byte)(this.h0 >> 8), (byte)this.h0, (byte)(this.h1 >> 24), (byte)(this.h1 >> 16), (byte)(this.h1 >> 8), (byte)this.h1, (byte)(this.h2 >> 24), (byte)(this.h2 >> 16), (byte)(this.h2 >> 8), (byte)this.h2, (byte)(this.h3 >> 24), (byte)(this.h3 >> 16), (byte)(this.h3 >> 8), (byte)this.h3, (byte)(this.h4 >> 24), (byte)(this.h4 >> 16), (byte)(this.h4 >> 8), (byte)this.h4, (byte)(this.h5 >> 24), (byte)(this.h5 >> 16), (byte)(this.h5 >> 8), (byte)this.h5, (byte)(this.h6 >> 24), (byte)(this.h6 >> 16), (byte)(this.h6 >> 8), (byte)this.h6, (byte)(this.h7 >> 24), (byte)(this.h7 >> 16), (byte)(this.h7 >> 8), (byte)this.h7};
    }

    private void sha(byte[] in, int offset) {
        int T2;
        int T;
        int r;
        int A = this.h0;
        int B = this.h1;
        int C = this.h2;
        int D = this.h3;
        int E = this.h4;
        int F = this.h5;
        int G = this.h6;
        int H = this.h7;
        for (r = 0; r < 16; ++r) {
            this.w[r] = in[offset] << 24 | (in[offset + 1] & 0xFF) << 16 | (in[offset + 2] & 0xFF) << 8 | in[offset + 3] & 0xFF;
            offset += 4;
        }
        for (r = 16; r < 64; ++r) {
            T = this.w[r - 2];
            T2 = this.w[r - 15];
            this.w[r] = ((HashingSha256.s(T, 17) | T << 15) ^ (HashingSha256.s(T, 19) | T << 13) ^ HashingSha256.s(T, 10)) + this.w[r - 7] + ((HashingSha256.s(T2, 7) | T2 << 25) ^ (HashingSha256.s(T2, 18) | T2 << 14) ^ HashingSha256.s(T2, 3)) + this.w[r - 16];
        }
        for (r = 0; r < 64; ++r) {
            T = H + ((HashingSha256.s(E, 6) | E << 26) ^ (HashingSha256.s(E, 11) | E << 21) ^ (HashingSha256.s(E, 25) | E << 7)) + (E & F ^ ~E & G) + k[r] + this.w[r];
            T2 = ((HashingSha256.s(A, 2) | A << 30) ^ (HashingSha256.s(A, 13) | A << 19) ^ (HashingSha256.s(A, 22) | A << 10)) + (A & B ^ A & C ^ B & C);
            H = G;
            G = F;
            F = E;
            E = D + T;
            D = C;
            C = B;
            B = A;
            A = T + T2;
        }
        this.h0 += A;
        this.h1 += B;
        this.h2 += C;
        this.h3 += D;
        this.h4 += E;
        this.h5 += F;
        this.h6 += G;
        this.h7 += H;
    }

    private static int s(int a, int b) {
        return a >>> b;
    }

    public static byte[] hash(byte[] bytes) {
        HashingSha256 instance = new HashingSha256();
        instance.initialize();
        if (bytes != null) {
            instance.update(bytes, 0, bytes.length);
        }
        return instance.digest();
    }

    public static byte[] hash(byte[] bytes, int index, int length) {
        if (bytes == null || bytes.length <= 0) {
            HashingSha256 instance = new HashingSha256();
            instance.initialize();
            return instance.digest();
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.length - index) {
            length = bytes.length - index;
        }
        if (length <= 0) {
            HashingSha256 instance = new HashingSha256();
            instance.initialize();
            return instance.digest();
        }
        HashingSha256 instance = new HashingSha256();
        instance.initialize();
        instance.update(bytes, index, length);
        return instance.digest();
    }
}

