/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.entities.events;

import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.entities.events.EventHook;
import com.snaju.nebula.service.EventService;
import java.util.LinkedList;

public interface Event<C> {
    public static final boolean isCanceled = false;

    default public C call() {
        EventService eventService = (EventService)SpaceSDK.getInstance().getInjector().getInstance(EventService.class);
        if (eventService != null) {
            if (!eventService.getHooks().containsKey(this.getClass())) {
                eventService.getHooks().put(this.getClass(), new LinkedList());
            }
            if (eventService.getHooks().containsKey(this.getClass())) {
                for (EventHook hook : eventService.getHooks().get(this.getClass())) {
                    if (this.isCanceled()) break;
                    hook.run(this);
                }
                if (!this.isCanceled()) {
                    this.fallback();
                }
            } else {
                System.err.println("No Event Hooks for event " + this.getClass());
            }
        } else {
            System.err.println("Failed to call Event, EventService is not started... skipping.");
        }
        return (C)this;
    }

    default public boolean isCanceled() {
        return false;
    }

    default public C fallback() {
        return (C)this;
    }
}

