/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.utility;

import java.util.Collection;
import lowentry.ue4.classes.utility.FlippableSet;
import lowentry.ue4.library.LowEntry;

public class TimedFlippableSet<T>
extends FlippableSet<T> {
    protected final long timeoutMs;
    protected long timeRemainingMs;
    protected long lastFlipTimeMs;

    public TimedFlippableSet(long timeoutMs) {
        this.timeoutMs = timeoutMs;
        this.timeRemainingMs = timeoutMs;
        this.lastFlipTimeMs = LowEntry.millis();
    }

    public Collection<T> tryFlip() {
        long timeMs = LowEntry.millis();
        this.timeRemainingMs -= timeMs - this.lastFlipTimeMs;
        this.lastFlipTimeMs = timeMs;
        if (this.timeRemainingMs > 0L) {
            return null;
        }
        this.timeRemainingMs += this.timeoutMs;
        return super.flip();
    }

    @Override
    public Collection<T> flip() {
        this.timeRemainingMs = this.timeoutMs;
        this.lastFlipTimeMs = LowEntry.millis();
        return super.flip();
    }
}

