/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.utility;

import java.util.Map;
import lowentry.ue4.classes.utility.FlippableCounter;
import lowentry.ue4.library.LowEntry;

public class TimedFlippableCounter<K>
extends FlippableCounter<K> {
    protected final long timeoutMs;
    protected long timeRemainingMs;
    protected long lastFlipTimeMs;

    public TimedFlippableCounter(long timeoutMs) {
        this.timeoutMs = timeoutMs;
        this.timeRemainingMs = timeoutMs;
        this.lastFlipTimeMs = LowEntry.millis();
    }

    public Map<K, Long> tryFlip() {
        long timeMs = LowEntry.millis();
        this.timeRemainingMs -= timeMs - this.lastFlipTimeMs;
        this.lastFlipTimeMs = timeMs;
        if (this.timeRemainingMs > 0L) {
            return null;
        }
        this.timeRemainingMs += this.timeoutMs;
        return super.flip();
    }

    @Override
    public Map<K, Long> flip() {
        this.timeRemainingMs = this.timeoutMs;
        this.lastFlipTimeMs = LowEntry.millis();
        return super.flip();
    }
}

