/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.internal;

import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.TimeZone;
import lowentry.ue4.classes.ParsedHashcash;
import lowentry.ue4.classes.internal.CachedTime;
import lowentry.ue4.library.LowEntry;

public class HashingHashcash {
    private static final int VERSION = 1;
    private static final int MAX_COUNTER = 0x100000;
    private static final String DATE_FORMAT_STRING = "yyMMddHHmmss";
    private static final String DATE_FORMAT_STRING_B = "yyMMdd";
    private static final String DATE_FORMAT_STRING_C = "yyMMddHHmm";
    private static final byte[][] BASE_64_CACHE = new byte[0x100000][];
    private static final ThreadLocal<DateFormat> dateFormat;
    private static final ThreadLocal<DateFormat> dateFormatB;
    private static final ThreadLocal<DateFormat> dateFormatC;

    public static String[] hash(String[] resource, int bits) {
        return HashingHashcash.hash(resource, null, bits);
    }

    public static String[] hash(String[] resources, Date date, int bits) {
        if (resources == null) {
            return new String[0];
        }
        if (date == null) {
            date = new Date(CachedTime.currentTimeMillis());
        }
        String[] result = new String[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            result[i] = HashingHashcash.hash(resources[i], date, bits);
        }
        return result;
    }

    public static String hash(String resource, int bits) {
        return HashingHashcash.hash(resource, null, bits);
    }

    public static String hash(String resource, Date date, int bits) {
        if (resource == null) {
            resource = "";
        }
        if (date == null) {
            date = new Date(CachedTime.currentTimeMillis());
        }
        MessageDigest hasher = LowEntry.hashingDigestSha1.get();
        byte[] hashBuffer = new byte[160];
        String dataPrefix = "1:" + bits + ":" + HashingHashcash.getDateString(date) + ":" + resource + "::";
        byte[] dataPrefixBytes = LowEntry.stringToBytesUtf8(dataPrefix);
        ByteBuffer buffer = ByteBuffer.allocate(dataPrefixBytes.length + 17 + 8);
        buffer.put(dataPrefixBytes);
        int prefixpos = buffer.position();
        block2: while (true) {
            buffer.position(prefixpos);
            buffer.put(LowEntry.stringToBytesUtf8(LowEntry.bytesToBase64(LowEntry.generateRandomBytesFast(12)) + ":"));
            byte[][] byArray = BASE_64_CACHE;
            int n = byArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block2;
                byte[] base64counter = byArray[n2];
                try {
                    hasher.reset();
                    hasher.update(buffer.array(), buffer.arrayOffset(), buffer.position());
                    hasher.update(base64counter);
                    hasher.digest(hashBuffer, 0, hashBuffer.length);
                }
                catch (DigestException e) {
                    throw new RuntimeException(e);
                }
                int leadingZeroBits = HashingHashcash.countLeadingZeroBits(hashBuffer);
                if (leadingZeroBits >= bits) {
                    buffer.put(base64counter);
                    return LowEntry.bytesToStringUtf8(buffer.array(), buffer.arrayOffset(), buffer.position());
                }
                ++n2;
            }
            break;
        }
    }

    public static ParsedHashcash[] parse(String[] hashes) {
        if (hashes == null) {
            return new ParsedHashcash[0];
        }
        ParsedHashcash[] result = new ParsedHashcash[hashes.length];
        for (int i = 0; i < hashes.length; ++i) {
            result[i] = HashingHashcash.parse(hashes[i]);
        }
        return result;
    }

    public static ParsedHashcash parse(String hash) {
        String[] parts;
        if (hash != null && (parts = hash.split(":")).length >= 6) {
            Date date;
            String version = parts[0];
            if ("0".equals(version)) {
                Date date2 = HashingHashcash.parseDateString(parts[1]);
                if (date2 != null) {
                    int bits = HashingHashcash.countLeadingZeroBits(LowEntry.sha1(LowEntry.stringToBytesUtf8(hash)));
                    StringBuilder resource = new StringBuilder(parts[2]);
                    for (int i = 3; i < parts.length - 3; ++i) {
                        resource.append(':');
                        resource.append(parts[i]);
                    }
                    return new ParsedHashcash(true, resource.toString(), date2, bits);
                }
            } else if ("1".equals(version) && parts.length >= 7 && (date = HashingHashcash.parseDateString(parts[2])) != null) {
                int bits = Integer.parseInt(parts[1]);
                if (HashingHashcash.countLeadingZeroBits(LowEntry.sha1(LowEntry.stringToBytesUtf8(hash))) >= bits) {
                    StringBuilder resource = new StringBuilder(parts[3]);
                    for (int i = 4; i < parts.length - 3; ++i) {
                        resource.append(':');
                        resource.append(parts[i]);
                    }
                    return new ParsedHashcash(true, resource.toString(), date, bits);
                }
            }
        }
        return new ParsedHashcash(false, null, null, 0);
    }

    private static byte[] base64WithoutLeadingZeroBytes(int value) {
        byte[] bytes = value < 0 ? new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value} : (value < 256 ? new byte[]{(byte)value} : (value < 65536 ? new byte[]{(byte)(value >> 8), (byte)value} : (value < 0x1000000 ? new byte[]{(byte)(value >> 16), (byte)(value >> 8), (byte)value} : new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value})));
        return Base64.getEncoder().encode(bytes);
    }

    private static String getDateString(Date date) {
        return dateFormat.get().format(date);
    }

    private static Date parseDateString(String date) {
        try {
            return dateFormat.get().parse(date);
        }
        catch (ParseException e) {
            try {
                return dateFormatB.get().parse(date);
            }
            catch (ParseException e2) {
                try {
                    return dateFormatC.get().parse(date);
                }
                catch (ParseException e3) {
                    return null;
                }
            }
        }
    }

    private static int countLeadingZeroBits(byte[] values) {
        int total = 0;
        for (byte value : values) {
            byte ofbyte = HashingHashcash.countLeadingZeroBits(value);
            total += ofbyte;
            if (ofbyte != 8) break;
        }
        return total;
    }

    private static byte countLeadingZeroBits(byte v) {
        if (v < 0) {
            return 0;
        }
        if (v < 1) {
            return 8;
        }
        if (v < 2) {
            return 7;
        }
        if (v < 4) {
            return 6;
        }
        if (v < 8) {
            return 5;
        }
        if (v < 16) {
            return 4;
        }
        if (v < 32) {
            return 3;
        }
        if (v < 64) {
            return 2;
        }
        return 1;
    }

    static {
        for (int i = 0; i < BASE_64_CACHE.length; ++i) {
            HashingHashcash.BASE_64_CACHE[i] = HashingHashcash.base64WithoutLeadingZeroBytes(i);
        }
        dateFormat = ThreadLocal.withInitial(() -> {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            dateFormat.setLenient(false);
            return dateFormat;
        });
        dateFormatB = ThreadLocal.withInitial(() -> {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_STRING_B);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            dateFormat.setLenient(false);
            return dateFormat;
        });
        dateFormatC = ThreadLocal.withInitial(() -> {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_STRING_C);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            dateFormat.setLenient(false);
            return dateFormat;
        });
    }
}

