/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.utils;

import com.snaju.nebula.utils.CRC16;
import fr.devnied.bitlib.BitUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BufferUtil {
    public static void putUnsignedByte(ByteBuffer buf, int value) {
        buf.put((byte)(value & 0xFF));
    }

    public static void putUnsignedShort(ByteBuffer buf, int value) {
        buf.putShort((short)(value & 0xFFFF));
    }

    public static void putUnsignedInt(ByteBuffer buf, long value) {
        buf.putInt((int)(value & 0xFFFFFFFFL));
    }

    public static byte[] buffetToArray(ByteBuffer buffer, int size) {
        byte[] arr = new byte[size];
        buffer.position(0);
        buffer.get(arr, 0, buffer.remaining());
        return arr;
    }

    public static ByteBuffer combine(ByteBuffer ... buffers) {
        int size = 0;
        for (ByteBuffer b : buffers) {
            size += b.capacity();
        }
        ByteBuffer finalB = ByteBuffer.allocate(size);
        for (ByteBuffer b : buffers) {
            BufferUtil.push(b, finalB);
        }
        return finalB;
    }

    public static byte[] combineToArray(ByteBuffer ... buffers) {
        return BufferUtil.combine(buffers).array();
    }

    public static byte[] bufferToArray(ByteBuffer buffer, int start, int len) {
        byte[] arr = new byte[len];
        buffer.position(start);
        buffer.get(arr, start, len);
        return arr;
    }

    public static ByteBuffer push(ByteBuffer byteBuffer, byte[] bytes) {
        for (byte b : bytes) {
            byteBuffer.put(b);
        }
        return byteBuffer;
    }

    public static ByteBuffer push(ByteBuffer byteBuffer, ByteBuffer add) {
        for (byte b : add.array()) {
            byteBuffer.put(b);
        }
        return byteBuffer;
    }

    public static CRC16 calcCRC16Checksum(CRC16 crc16, byte[] bytes) {
        return crc16;
    }

    public static CRC16 calcCRC16Checksum(CRC16 crc16, ByteBuffer buffer) {
        return BufferUtil.calcCRC16Checksum(crc16, buffer.array());
    }

    public static byte[] getSplice(ByteBuffer buffer, int start, int length) {
        int currentPos = buffer.position();
        buffer.position(start);
        byte[] n = new byte[length];
        int i = 0;
        while (buffer.position() < start + length) {
            if (i >= n.length) continue;
            n[i++] = buffer.get();
        }
        buffer.position(currentPos);
        return n;
    }

    public static ByteBuffer getSplice(ByteBuffer buffer, ByteOrder order, int start, int length) {
        int currentPos = buffer.position();
        buffer.position(start);
        ByteBuffer n = ByteBuffer.allocate(length);
        n.order(order);
        int i = 0;
        while (buffer.position() < start + length) {
            if (i < n.capacity()) {
                n.put(buffer.get());
            }
            ++i;
        }
        buffer.position(currentPos);
        return n;
    }

    public static byte[] getNextPart(ByteBuffer buffer, int length) {
        byte[] n = new byte[length];
        int i = 0;
        while (i < length) {
            n[i++] = buffer.get();
        }
        return n;
    }

    public static ByteBuffer getNextPart(ByteBuffer buffer, ByteOrder order, int length) {
        ByteBuffer n = ByteBuffer.allocate(length);
        n.order(order);
        for (int i = 0; i < length; ++i) {
            n.put(buffer.get());
        }
        return n;
    }

    public static void zeroFillBuffer(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            BitUtils b = new BitUtils(8);
            b.setNextInteger(0, 8);
            buffer.put(b.getData());
        }
    }

    public static short invert(short value) {
        return (short)((value & 0xFF) << 8 | (value & 0xFF00) >> 8);
    }

    public static int invert(int value) {
        return (value & 0xFF000000) >> 24 | (value & 0xFF0000) >> 8 | (value & 0xFF00) << 8 | (value & 0xFF) << 24;
    }

    public static byte invert(byte value) {
        return (byte)((value & 0xFF) << 8 | (value & 0xFF00) >> 8);
    }

    public static boolean searchAndSetPosition(ByteBuffer buffer, byte[] pattern) {
        int patternPosition = 0;
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if (b == pattern[patternPosition]) {
                if (++patternPosition != pattern.length) continue;
                buffer.position(buffer.position() - pattern.length);
                return true;
            }
            if (patternPosition <= 0) continue;
            buffer.position(buffer.position() - patternPosition);
            patternPosition = 0;
        }
        return false;
    }
}

