/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.threads;

import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.service.TaskService;

public class TaskThread
implements Runnable {
    public static volatile long tps = 20L;
    private long tickCounter = 0L;
    private long lastSecond = System.currentTimeMillis();

    @Override
    public void run() {
        long sleepTime = 5L;
        TaskService taskService = (TaskService)SpaceSDK.getInstance().getInjector().getInstance(TaskService.class);
        while (true) {
            long start = System.currentTimeMillis();
            try {
                taskService.tick();
                ++this.tickCounter;
                long now = System.currentTimeMillis();
                if (now - this.lastSecond >= 1000L) {
                    tps = this.tickCounter;
                    this.tickCounter = 0L;
                    this.lastSecond = now;
                }
                long deltaTime = now - start;
                sleepTime = Math.max(1L, 50L - deltaTime);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

