/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.struts;

import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.entities.strut.ByteOrder;
import com.snaju.nebula.entities.strut.Strut;
import com.snaju.nebula.entities.strut.StrutElement;
import com.snaju.nebula.entities.strut.StrutInterface;
import com.snaju.nebula.service.LogServiceOld;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

@Strut(byteOrder=ByteOrder.BIG)
public class CCSDSHeaderStrut
extends StrutInterface<CCSDSHeaderStrut> {
    @StrutElement
    public short w1 = 0;
    @StrutElement
    public short w2 = 0;
    @StrutElement
    public short packetSize = 0;
    @StrutElement
    public int time = 0;
    @StrutElement
    public short w6 = 0;
    @StrutElement
    public short word7 = 0;
    @StrutElement
    public short word8 = 0;
    private LogServiceOld ls = (LogServiceOld)SpaceSDK.getInstance().getInjector().getInstance(LogServiceOld.class);

    public CCSDSHeaderStrut(int apid, int packetSeqCount, short packetLength, int packetType, short word7, short word8) throws Exception {
        DateTime dt = new DateTime();
        this.w1 = (short)(apid | 0x1800);
        this.w2 = (short)(packetSeqCount | 0xC000);
        this.packetSize = packetLength;
        DateTime baseTime = new DateTime();
        baseTime.withYear(1980).withDayOfMonth(6).withMonthOfYear(1).withTimeAtStartOfDay();
        DateTime now = DateTime.now();
        Seconds diff = Seconds.secondsBetween((ReadableInstant)now, (ReadableInstant)baseTime);
        this.time = Math.abs(diff.getSeconds());
        this.w6 = (short)(0x60 | packetType);
        this.word7 = word7;
        this.word8 = word8;
        this.init();
    }

    public CCSDSHeaderStrut() {
        try {
            this.init();
        }
        catch (Exception e) {
            this.ls.fatal(ExceptionUtils.getStackTrace((Throwable)e));
            e.printStackTrace();
        }
    }

    public short getPacketSize() {
        return this.packetSize;
    }

    public void setPacketSize(short packetSize) {
        this.packetSize = packetSize;
    }
}

