/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.service;

import com.google.inject.Injector;
import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.entities.events.Event;
import com.snaju.nebula.entities.events.EventHandler;
import com.snaju.nebula.entities.events.EventHook;
import com.snaju.nebula.entities.events.EventInterface;
import com.snaju.nebula.injection.GuiceServiceLoader;
import com.snaju.nebula.service.LogServiceOld;
import com.snaju.nebula.service.Service;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

@Singleton
public class EventService
implements Service<Event>,
EventInterface {
    private ConcurrentHashMap<Class, LinkedList<EventHook>> hooks = new ConcurrentHashMap();
    private LogServiceOld ls = (LogServiceOld)SpaceSDK.getInstance().getInjector().getInstance(LogServiceOld.class);

    @Override
    public void init() {
        System.out.println(this.ls.info("---- Event Service"));
        GuiceServiceLoader.load(Event.class, SpaceSDK.getInstance().getClass().getClassLoader()).forEach(this::register);
        this.loadEvents(this.getClass().getClassLoader(), SpaceSDK.getInstance().getInjector(), "com.snaju.nebula");
    }

    @Override
    public void register(Event event) {
        System.out.println(this.ls.info("Registered Event: " + event.getClass().getSimpleName()));
        this.hooks.put(event.getClass(), new LinkedList());
    }

    public void registerListener(EventInterface listener) {
        Class<?> c = listener.getClass();
        System.out.println(this.ls.info("Manually registering listener: " + c.getSimpleName()));
        for (Method m : c.getMethods()) {
            m.setAccessible(true);
            if (!m.isAnnotationPresent(EventHandler.class)) continue;
            Parameter[] params = m.getParameters();
            if (params.length != 1) {
                System.err.println(this.ls.error("Invalid EventHandler signature in " + c.getSimpleName() + "::" + m.getName() + ". Must have exactly 1 parameter."));
                continue;
            }
            Class<?> hookTo = params[0].getType();
            System.out.println(this.ls.info("  -> Hooked " + m.getName() + " to " + hookTo.getSimpleName()));
            this.hooks.computeIfAbsent(hookTo, k -> new LinkedList());
            this.hooks.get(hookTo).add(event -> {
                try {
                    m.setAccessible(true);
                    m.invoke((Object)listener, event);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.ls.fatal("Error executing manual event hook in " + c.getSimpleName() + "\n" + ExceptionUtils.getStackTrace((Throwable)e));
                    e.printStackTrace();
                }
            });
        }
    }

    public void loadEvents(ClassLoader classLoader, Injector injector, String packagePrefix) {
        try {
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(ClasspathHelper.forPackage((String)packagePrefix, (ClassLoader[])new ClassLoader[]{classLoader})).addClassLoaders(new ClassLoader[]{classLoader}).setScanners(new Scanner[]{Scanners.TypesAnnotated, Scanners.SubTypes}));
            Set eventHandlers = reflections.getSubTypesOf(EventInterface.class);
            if (eventHandlers.isEmpty()) {
                // empty if block
            }
            for (Class c : eventHandlers) {
                System.out.println(this.ls.info("Scanning Class " + c.getSimpleName()));
                for (Method m : c.getMethods()) {
                    m.setAccessible(true);
                    if (m.getAnnotation(EventHandler.class) == null) continue;
                    System.out.println(this.ls.info("Event Handler " + m.getName() + " Found inside " + c.getSimpleName()));
                    for (Parameter p : m.getParameters()) {
                        Class<?> hookTo = p.getType();
                        if (!this.hooks.containsKey(hookTo)) {
                            this.hooks.put(hookTo, new LinkedList());
                        }
                        this.hooks.get(hookTo).add(event -> {
                            try {
                                EventInterface eventInterface = (EventInterface)injector.getInstance(c);
                                m.setAccessible(true);
                                m.invoke((Object)eventInterface, event);
                            }
                            catch (IllegalAccessException | InvocationTargetException e) {
                                this.ls.fatal("Error executing event hook in " + c.getSimpleName() + "\n" + ExceptionUtils.getStackTrace((Throwable)e));
                                e.printStackTrace();
                            }
                        });
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println(this.ls.error("Failed to scan events for " + packagePrefix));
            e.printStackTrace();
        }
    }

    public ConcurrentHashMap<Class, LinkedList<EventHook>> getHooks() {
        return this.hooks;
    }

    @Override
    public String getName() {
        return "EventService";
    }

    @Override
    public LogServiceOld getLogger() {
        return this.ls;
    }
}

