/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.entities.socket.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public abstract class NebulaUDPListener {
    private DatagramSocket socket;
    private Thread listenerThread;
    private volatile boolean running = false;
    private final int bufferSize;

    public NebulaUDPListener(int port) throws IOException {
        this(port, 2048);
    }

    public NebulaUDPListener(int port, int bufferSize) throws IOException {
        this.socket = new DatagramSocket(port);
        this.bufferSize = bufferSize;
    }

    public NebulaUDPListener(DatagramSocket socket) {
        this.socket = socket;
        this.bufferSize = 2048;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.listenerThread = new Thread(() -> {
            while (this.running) {
                try {
                    byte[] buffer = new byte[this.bufferSize];
                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                    this.socket.receive(packet);
                    byte[] data = new byte[packet.getLength()];
                    System.arraycopy(packet.getData(), packet.getOffset(), data, 0, packet.getLength());
                    this.processPacket(data, packet.getAddress(), packet.getPort());
                }
                catch (IOException e) {
                    if (!this.running) continue;
                    this.handleError(e);
                }
            }
        }, "NebulaUDPListener-Thread");
        this.listenerThread.start();
    }

    public void stop() {
        this.running = false;
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    protected abstract void processPacket(byte[] var1, InetAddress var2, int var3);

    protected void handleError(Exception e) {
        e.printStackTrace();
    }
}

