/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.entities.plugin;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.snaju.nebula.entities.plugin.PluginClassLoader;
import com.snaju.nebula.entities.plugin.SpacePlugin;
import com.snaju.nebula.service.EventService;
import com.snaju.nebula.service.LogServiceOld;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Singleton
public class PluginManager {
    private LinkedList<PluginObject> loadQueue = new LinkedList();
    public LinkedList<SpacePlugin> plugins = new LinkedList();
    private List<Class<? extends SpacePlugin>> discoveredPluginClasses = new ArrayList<Class<? extends SpacePlugin>>();
    private PluginClassLoader sharedLoader;

    public void loadClasses() {
        System.out.println("[INFO] ---- Discovering Plugins");
        try {
            Path pluginPath = Paths.get("plugins", new String[0]);
            Files.createDirectories(pluginPath, new FileAttribute[0]);
            File pluginDir = pluginPath.toFile();
            List pluginFiles = (List)FileUtils.listFiles((File)pluginDir, (String[])new String[]{"jar"}, (boolean)false);
            URL[] urls = (URL[])pluginFiles.stream().map(f -> {
                try {
                    return f.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(URL[]::new);
            this.sharedLoader = new PluginClassLoader(urls, this.getClass().getClassLoader());
            ArrayList<PluginObject> rawDiscovery = new ArrayList<PluginObject>();
            for (File f2 : pluginFiles) {
                try (JarFile jar = new JarFile(f2);){
                    JarEntry entry = jar.getJarEntry("plugin.properties");
                    if (entry == null) continue;
                    InputStream stream = jar.getInputStream(entry);
                    try {
                        Properties props = new Properties();
                        props.load(stream);
                        String mainClass = props.getProperty("main");
                        String name = props.getProperty("name");
                        String dependsRaw = props.getProperty("depends", "");
                        List<String> depends = Arrays.stream(dependsRaw.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
                        PluginObject obj = new PluginObject(name, mainClass, f2, this.sharedLoader, depends);
                        rawDiscovery.add(obj);
                        System.out.println("[INFO] Discovered Plugin: " + name);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    System.err.println("Error reading plugin jar: " + f2.getName());
                }
            }
            this.resolveAndSortPlugins(rawDiscovery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void resolveAndSortPlugins(List<PluginObject> rawList) {
        HashMap<String, PluginObject> pluginMap = new HashMap<String, PluginObject>();
        for (PluginObject obj : rawList) {
            pluginMap.put(obj.name, obj);
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            Iterator it = pluginMap.entrySet().iterator();
            block4: while (it.hasNext()) {
                PluginObject obj = (PluginObject)it.next().getValue();
                for (String dep : obj.depends) {
                    if (pluginMap.containsKey(dep)) continue;
                    System.err.println("[WARN] Skipping plugin '" + obj.name + "' because missing dependency: " + dep);
                    it.remove();
                    changed = true;
                    continue block4;
                }
            }
        }
        LinkedList<PluginObject> sortedList = new LinkedList<PluginObject>();
        HashSet<String> visited = new HashSet<String>();
        HashSet<String> processing = new HashSet<String>();
        for (PluginObject obj : pluginMap.values()) {
            try {
                this.sortRecursive(obj, pluginMap, visited, processing, sortedList);
            }
            catch (IllegalStateException e) {
                System.err.println("[ERROR] Circular dependency detected! Skipping cluster containing: " + obj.name);
            }
        }
        this.loadQueue = sortedList;
        System.out.println("[INFO] Dependency Order Resolved: " + sortedList.stream().map(p -> p.name).collect(Collectors.joining(" -> ")));
    }

    private void sortRecursive(PluginObject current, Map<String, PluginObject> allPlugins, Set<String> visited, Set<String> processing, LinkedList<PluginObject> sorted) {
        if (visited.contains(current.name)) {
            return;
        }
        if (processing.contains(current.name)) {
            throw new IllegalStateException("Circular dependency detected: " + current.name);
        }
        processing.add(current.name);
        for (String depName : current.depends) {
            PluginObject dep = allPlugins.get(depName);
            if (dep == null) continue;
            this.sortRecursive(dep, allPlugins, visited, processing, sorted);
        }
        processing.remove(current.name);
        visited.add(current.name);
        sorted.add(current);
    }

    public List<Module> getDiscoveredModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (PluginObject obj : this.loadQueue) {
            try {
                Class<?> mClass = Class.forName(obj.mainClass, true, obj.classLoader);
                if (!SpacePlugin.class.isAssignableFrom(mClass)) continue;
                SpacePlugin tempInstance = (SpacePlugin)mClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                modules.addAll(tempInstance.getModules());
                this.discoveredPluginClasses.add(mClass);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return modules;
    }

    public void enablePlugins(Injector injector) {
        LogServiceOld ls = (LogServiceOld)injector.getInstance(LogServiceOld.class);
        EventService eventService = (EventService)injector.getInstance(EventService.class);
        System.out.println(ls.info("---- Enabling Plugins via Root Injector"));
        for (Class<? extends SpacePlugin> pluginClass : this.discoveredPluginClasses) {
            try {
                SpacePlugin plugin = (SpacePlugin)injector.getInstance(pluginClass);
                PluginObject metadata = this.loadQueue.stream().filter(po -> po.mainClass.equals(pluginClass.getName())).findFirst().orElse(null);
                if (metadata != null) {
                    plugin.setFile(metadata.file);
                }
                System.out.println(ls.info("Enabling Plugin: " + plugin.getClass().getSimpleName()));
                plugin.onEnable();
                eventService.loadEvents(plugin.getClass().getClassLoader(), injector, plugin.getClass().getPackage().getName());
                this.plugins.add(plugin);
            }
            catch (Exception e) {
                ls.fatal("Failed to enable plugin: " + pluginClass.getSimpleName() + "\n" + ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public PluginClassLoader getSharedLoader() {
        return this.sharedLoader;
    }

    public static class PluginObject {
        public String name;
        public String mainClass;
        public File file;
        public ClassLoader classLoader;
        public List<String> depends;

        public PluginObject(String name, String mainClass, File file, ClassLoader classLoader, List<String> depends) {
            this.name = name;
            this.mainClass = mainClass;
            this.file = file;
            this.classLoader = classLoader;
            this.depends = depends;
        }
    }
}

