/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula;

import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.snaju.nebula.entities.events.EventInterface;
import com.snaju.nebula.entities.plugin.PluginManager;
import com.snaju.nebula.injection.AppInjector;
import com.snaju.nebula.injection.GuiceServiceLoader;
import com.snaju.nebula.injection.InjectionModule;
import com.snaju.nebula.injection.InjectionRoot;
import com.snaju.nebula.service.EventService;
import com.snaju.nebula.service.LogService;
import com.snaju.nebula.service.LogServiceOld;
import com.snaju.nebula.service.Service;
import com.snaju.nebula.service.ThreadService;
import com.snaju.nebula.threads.TaskThread;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class SpaceSDK
implements InjectionRoot,
EventInterface {
    public static boolean isPrimary = false;
    private boolean isReady = false;
    private static LinkedList<String> namespaces = new LinkedList();
    private long powerOnTime;
    private static String apid;
    private static String nodeType;
    private static String subAddr;
    private static SpaceSDK instance;
    private PluginManager pluginManager;
    private LinkedList<String> subApids = new LinkedList();
    private String coreHash;
    public static boolean isServer;
    private static double version;
    private static String hash;
    private static File file;
    public static boolean hasUpdated;
    private static LogServiceOld ls;
    private static String preLogCatch;
    private static boolean preException;
    public LogService logService;
    @Inject
    private Injector injector;

    public SpaceSDK(boolean isServer) {
        isServer = false;
    }

    public SpaceSDK() {
    }

    public LogService getLogService() {
        return this.logService;
    }

    @Override
    public void onLoad() {
        instance = this;
        this.logService = new LogService();
        this.logService.init();
        this.pluginManager = new PluginManager();
        AppInjector.registerInjectionRoot(this);
        AppInjector.registerRootModule((Module)new InjectionModule());
        namespaces.push(this.getClass().getPackage().getName());
        if (isServer) {
            System.out.println("[BOOT] Loading Plugins...");
            this.pluginManager.loadClasses();
            List<Module> pluginModules = this.pluginManager.getDiscoveredModules();
            for (Module m : pluginModules) {
                AppInjector.registerRootModule(m);
            }
            System.out.println("[BOOT] Registered " + pluginModules.size() + " plugin modules to Root Injector.");
            try {
                File file = new File("/usr/local/nebula/nebula.pid");
                if (file.exists()) {
                    System.err.println("Nebula is already started somewhere else... Shutting Down.");
                    System.exit(0);
                } else {
                    String pidString = ManagementFactory.getRuntimeMXBean().getName();
                    String pid = pidString.split("@")[0];
                    FileWriter writer = new FileWriter(file.getPath());
                    writer.write(pid);
                    writer.close();
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                        File file2 = new File("/usr/local/nebula/nebula.pid");
                        if (file2.exists()) {
                            file2.delete();
                        }
                    }));
                    if (!file.exists()) {
                        throw new IOException("Failed to make Nebula PID file :(");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            hash = SpaceSDK.calcHash();
        }
    }

    public void onEnable() {
        instance = this;
        System.out.println("[INFO] -=-=-=-=-Service Module-=-=-=-=-");
        GuiceServiceLoader.load(Service.class, this.getClass().getClassLoader()).forEach(Service::init);
        ls = (LogServiceOld)SpaceSDK.getInstance().getInjector().getInstance(LogServiceOld.class);
        if (preException) {
            ls.fatal(preLogCatch);
        }
        ls.info("Main JAR Path: " + preLogCatch);
        ls.info("Version Number: " + version + " (" + hash + ")");
        ls.info("[INFO] -=-=-=-=-Service Module-=-=-=-=-");
        System.out.println(ls.info("-=-=-=-=-Enabling Plugins-=-=-=-=-"));
        this.pluginManager.enablePlugins(this.injector);
        if (hasUpdated) {
            System.out.println(ls.info("Rebooting Nebula due to update"));
            try {
                SpaceSDK.restart();
            }
            catch (IOException | URISyntaxException e) {
                ls.fatal(ExceptionUtils.getStackTrace((Throwable)e));
                e.printStackTrace();
            }
        }
        SpaceSDK.inject(ThreadService.class).runDedicatedThread("tick", new TaskThread());
        this.powerOnTime = System.currentTimeMillis();
        System.out.println(ls.info("System Boot Time: " + this.powerOnTime));
        this.isReady = true;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public EventService getEventService() {
        return (EventService)this.injector.getInstance(EventService.class);
    }

    public static String getApid() {
        return apid;
    }

    public static String getSubAddr() {
        return subAddr;
    }

    public static SpaceSDK getInstance() {
        return instance;
    }

    public Injector getInjector() {
        return this.injector;
    }

    public long getPowerOnTime() {
        return this.powerOnTime;
    }

    public long getSystemUpTime() {
        return System.currentTimeMillis() - this.powerOnTime;
    }

    public void addSubApid(String apid) {
        this.subApids.add(apid);
    }

    public LinkedList<String> getSubApids() {
        return this.subApids;
    }

    public static String getFullNodeId() {
        StringBuilder builder = new StringBuilder();
        builder.append(apid);
        if (subAddr != null && !subAddr.equalsIgnoreCase("")) {
            builder.append("-").append(subAddr);
        }
        return builder.toString();
    }

    public static void addNameSpace(String namespace) {
        if (!namespaces.contains(namespace)) {
            namespaces.push(namespace);
        }
    }

    public static LinkedList<String> getNamespaces() {
        return namespaces;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public static double getVersion() {
        return version;
    }

    private static String calcHash() {
        try {
            File jar;
            String jarPath = SpaceSDK.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            System.out.println("[INFO] Main JAR Path: " + jarPath);
            preLogCatch = jarPath;
            file = jar = new File(jarPath);
            return Files.asByteSource((File)jar).hash(Hashing.sha256()).toString().toUpperCase();
        }
        catch (Exception e) {
            preLogCatch = ExceptionUtils.getStackTrace((Throwable)e);
            preException = true;
            e.printStackTrace();
            return null;
        }
    }

    public static String getHash() {
        return hash;
    }

    public static void restart() throws IOException, URISyntaxException {
        System.out.println(ls.info("Restarting Snaju Nebula SDK.space"));
        File file = new File("/usr/local/nebula/nebula.pid");
        if (file.exists()) {
            file.delete();
            System.out.println(ls.info("Removing PID file..."));
            System.out.println(ls.info("Finding JAR file."));
            String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            File currentJar = new File(SpaceSDK.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (!currentJar.getName().endsWith(".jar")) {
                return;
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add(javaBin);
            command.add("-jar");
            command.add(currentJar.getPath());
            System.out.println(ls.info("Restarting..."));
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.start();
            System.exit(0);
        }
    }

    public static <C> C inject(Class<C> cClass) {
        return (C)SpaceSDK.getInstance().getInjector().getInstance(cClass);
    }

    public static boolean isIsPrimary() {
        return isPrimary;
    }

    public static String getNodeType() {
        return nodeType;
    }

    public static File getFile() {
        return file;
    }

    static {
        isServer = true;
        version = 1.1;
        hasUpdated = false;
        ls = null;
        preLogCatch = "";
        preException = false;
    }
}

