/*
 * Decompiled with CFR 0.152.
 */
package com.spacenetwork.mcs.nsl;

import com.google.inject.Inject;
import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.entities.plugin.SpacePlugin;
import com.snaju.nebula.entities.task.NebulaTask;
import com.snaju.nebula.entities.task.TickUnit;
import com.snaju.nebula.entities.task.types.RepeatingTask;
import com.snaju.nebula.service.CommService;
import com.snaju.nebula.service.TaskService;
import com.snaju.nebula.utils.BufferUtil;
import com.spacenetwork.leafspace.LeafSpaceCommAdapter;
import com.spacenetwork.mcs.services.CSPBuilder;
import com.spacenetwork.mcs.services.RedisService;
import fr.devnied.bitlib.BytesUtils;
import io.lettuce.core.api.sync.RedisCommands;
import java.nio.ByteBuffer;

public class NSLPlugin
extends SpacePlugin {
    @Inject
    RedisService redis;

    public void onEnable() {
        ((TaskService)SpaceSDK.inject(TaskService.class)).scheduleTask((NebulaTask)new RepeatingTask("csp-sender", TickUnit.SECONDS.toTicks(1L), TickUnit.SECONDS.toTicks(1L), false){

            public void run() {
                RedisCommands redis;
                String hexPayload;
                RedisService redisService = (RedisService)SpaceSDK.inject(RedisService.class);
                if (redisService.getRedisConnection().isOpen() && (hexPayload = (String)(redis = redisService.getRedisConnection().sync()).get((Object)"nsl_tx")) != null && !hexPayload.isEmpty()) {
                    try {
                        long seqNum;
                        String lastPayload = (String)redis.get((Object)"nsl_tx_last");
                        if (lastPayload == null || !lastPayload.equals(hexPayload)) {
                            seqNum = redis.incr((Object)"nsl_seq_tracker") % 255L;
                            if (seqNum == 0L) {
                                seqNum = redis.incr((Object)"nsl_seq_tracker");
                            }
                            redis.set((Object)"nsl_seq_current", (Object)String.valueOf(seqNum));
                            redis.set((Object)"nsl_tx_last", (Object)hexPayload);
                            System.out.println("New Command Detected. Incrementing Seq to: " + seqNum);
                        } else {
                            String currentSeqStr = (String)redis.get((Object)"nsl_seq_current");
                            if (currentSeqStr != null) {
                                seqNum = Long.parseLong(currentSeqStr);
                            } else {
                                seqNum = redis.incr((Object)"nsl_seq_tracker");
                                redis.set((Object)"nsl_seq_current", (Object)String.valueOf(seqNum));
                            }
                        }
                        byte[] nslPayload = BytesUtils.fromString((String)hexPayload);
                        byte groundDownSeq = 0;
                        byte groundUpSeq = (byte)seqNum;
                        ByteBuffer buff = ByteBuffer.allocate(nslPayload.length + 2);
                        buff.put(groundDownSeq);
                        buff.put(groundUpSeq);
                        BufferUtil.push((ByteBuffer)buff, (byte[])nslPayload);
                        ByteBuffer pingBuff = ByteBuffer.allocate(2);
                        pingBuff.put((byte)0);
                        pingBuff.put((byte)1);
                        byte[] nslFullPayload = CSPBuilder.buildCSPPayload((int)1, (int)10, (int)24, (int)8, (int)0, (int)0, (byte[])buff.array());
                        byte[] pingFullPayload = CSPBuilder.buildCSPPayload((int)2, (int)10, (int)22, (int)1, (int)54, (int)0, (byte[])pingBuff.array());
                        ((LeafSpaceCommAdapter)((CommService)SpaceSDK.inject(CommService.class)).getAdapterOfType(LeafSpaceCommAdapter.class)).sendUplink(1, pingFullPayload);
                        ((LeafSpaceCommAdapter)((CommService)SpaceSDK.inject(CommService.class)).getAdapterOfType(LeafSpaceCommAdapter.class)).sendUplink(2, pingFullPayload);
                        ((LeafSpaceCommAdapter)((CommService)SpaceSDK.inject(CommService.class)).getAdapterOfType(LeafSpaceCommAdapter.class)).sendUplink(3, pingFullPayload);
                        System.out.println("Sent NSL Ping Command. UpSeq: " + (groundUpSeq & 0xFF) + " | Size: " + pingFullPayload.length);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public static int packHeader(int priority, int source, int destination, int destPort, int sourcePort, int reserved, boolean hmac, boolean xtea, boolean rdp, boolean crc) {
        int header = 0;
        header |= (priority & 3) << 30;
        header |= (source & 0x1F) << 25;
        header |= (destination & 0x1F) << 20;
        header |= (destPort & 0x3F) << 14;
        header |= (sourcePort & 0x3F) << 8;
        header |= (reserved & 0xF) << 4;
        if (hmac) {
            header |= 8;
        }
        if (xtea) {
            header |= 4;
        }
        if (rdp) {
            header |= 2;
        }
        if (crc) {
            header |= 1;
        }
        return header;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public void onDisable() {
    }
}

