/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.internal.aes;

import lowentry.ue4.classes.AesKey1D;
import lowentry.ue4.classes.internal.aes.EncryptionAesFastEngineGeneral_NonJava;

public class EncryptionAesFastEngine1D_NonJava {
    private final int ROUNDS;
    private final int[] EW;
    private final int[] DW;
    public int C0 = 0;
    public int C1 = 0;
    public int C2 = 0;
    public int C3 = 0;
    public int C0store1 = 0;
    public int C1store1 = 0;
    public int C2store1 = 0;
    public int C3store1 = 0;
    public int C0store2 = 0;
    public int C1store2 = 0;
    public int C2store2 = 0;
    public int C3store2 = 0;

    public EncryptionAesFastEngine1D_NonJava(AesKey1D key) {
        this.ROUNDS = key.rounds;
        this.EW = key.encryptionW;
        this.DW = key.decryptionW;
    }

    private static int s(int a, int b) {
        return a >>> b;
    }

    public static AesKey1D generateAesKey(byte[] key) {
        return EncryptionAesFastEngine1D_NonJava.generateAesKeyCustom(key, true, true);
    }

    public static AesKey1D generateAesKeyCustom(byte[] key, boolean forEncryption, boolean forDecryption) {
        if (key == null) {
            return null;
        }
        int keyLen = key.length;
        if (keyLen != 16 && keyLen != 24 & keyLen != 32) {
            return null;
        }
        int kc = EncryptionAesFastEngine1D_NonJava.s(keyLen, 2);
        int rounds = kc + 6;
        int roundsx4 = rounds * 4;
        if (!forEncryption && !forDecryption) {
            return new AesKey1D(rounds, null, null);
        }
        int[] ew = new int[(rounds + 1) * 4];
        switch (kc) {
            case 4: {
                int t3;
                int t2;
                int t1;
                int t0;
                ew[0] = t0 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 0);
                ew[1] = t1 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 4);
                ew[2] = t2 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 8);
                ew[3] = t3 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 12);
                for (int i = 1; i <= 10; ++i) {
                    int ix = i * 4;
                    int u = EncryptionAesFastEngineGeneral_NonJava.subWord(EncryptionAesFastEngineGeneral_NonJava.shift(t3, 8)) ^ EncryptionAesFastEngineGeneral_NonJava.rcon[i - 1];
                    ew[ix] = t0 ^= u;
                    ew[ix + 1] = t1 ^= t0;
                    ew[ix + 2] = t2 ^= t1;
                    ew[ix + 3] = t3 ^= t2;
                }
                break;
            }
            case 6: {
                int t5;
                int t4;
                int t3;
                int t2;
                int t1;
                int t0;
                ew[0] = t0 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 0);
                ew[1] = t1 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 4);
                ew[2] = t2 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 8);
                ew[3] = t3 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 12);
                ew[4] = t4 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 16);
                ew[5] = t5 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 20);
                int rcon = 1;
                int u = EncryptionAesFastEngineGeneral_NonJava.subWord(EncryptionAesFastEngineGeneral_NonJava.shift(t5, 8)) ^ rcon;
                rcon <<= 1;
                ew[6] = t0 ^= u;
                ew[7] = t1 ^= t0;
                ew[8] = t2 ^= t1;
                ew[9] = t3 ^= t2;
                ew[10] = t4 ^= t3;
                ew[11] = t5 ^= t4;
                for (int i = 3; i < 12; i += 3) {
                    int ix = i * 4;
                    u = EncryptionAesFastEngineGeneral_NonJava.subWord(EncryptionAesFastEngineGeneral_NonJava.shift(t5, 8)) ^ rcon;
                    rcon <<= 1;
                    ew[ix] = t0 ^= u;
                    ew[ix + 1] = t1 ^= t0;
                    ew[ix + 2] = t2 ^= t1;
                    ew[ix + 3] = t3 ^= t2;
                    ew[ix + 4] = t4 ^= t3;
                    ew[ix + 5] = t5 ^= t4;
                    u = EncryptionAesFastEngineGeneral_NonJava.subWord(EncryptionAesFastEngineGeneral_NonJava.shift(t5, 8)) ^ rcon;
                    rcon <<= 1;
                    ew[ix + 6] = t0 ^= u;
                    ew[ix + 7] = t1 ^= t0;
                    ew[ix + 8] = t2 ^= t1;
                    ew[ix + 9] = t3 ^= t2;
                    ew[ix + 10] = t4 ^= t3;
                    ew[ix + 11] = t5 ^= t4;
                }
                u = EncryptionAesFastEngineGeneral_NonJava.subWord(EncryptionAesFastEngineGeneral_NonJava.shift(t5, 8)) ^ rcon;
                ew[48] = t0 ^= u;
                ew[49] = t1 ^= t0;
                ew[50] = t2 ^= t1;
                ew[51] = t3 ^= t2;
                break;
            }
            case 8: {
                int u;
                int t7;
                int t6;
                int t5;
                int t4;
                int t3;
                int t2;
                int t1;
                int t0;
                ew[0] = t0 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 0);
                ew[1] = t1 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 4);
                ew[2] = t2 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 8);
                ew[3] = t3 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 12);
                ew[4] = t4 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 16);
                ew[5] = t5 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 20);
                ew[6] = t6 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 24);
                ew[7] = t7 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 28);
                int rcon = 1;
                for (int i = 2; i < 14; i += 2) {
                    int ix = i * 4;
                    u = EncryptionAesFastEngineGeneral_NonJava.subWord(EncryptionAesFastEngineGeneral_NonJava.shift(t7, 8)) ^ rcon;
                    rcon <<= 1;
                    ew[ix] = t0 ^= u;
                    ew[ix + 1] = t1 ^= t0;
                    ew[ix + 2] = t2 ^= t1;
                    ew[ix + 3] = t3 ^= t2;
                    u = EncryptionAesFastEngineGeneral_NonJava.subWord(t3);
                    ew[ix + 4] = t4 ^= u;
                    ew[ix + 5] = t5 ^= t4;
                    ew[ix + 6] = t6 ^= t5;
                    ew[ix + 7] = t7 ^= t6;
                }
                u = EncryptionAesFastEngineGeneral_NonJava.subWord(EncryptionAesFastEngineGeneral_NonJava.shift(t7, 8)) ^ rcon;
                ew[56] = t0 ^= u;
                ew[57] = t1 ^= t0;
                ew[58] = t2 ^= t1;
                ew[59] = t3 ^= t2;
                break;
            }
            default: {
                return null;
            }
        }
        if (!forDecryption) {
            return new AesKey1D(rounds, ew, null);
        }
        if (!forEncryption) {
            for (int i = 4; i < roundsx4; ++i) {
                ew[i] = EncryptionAesFastEngineGeneral_NonJava.inv_mcol(ew[i]);
            }
            return new AesKey1D(rounds, null, ew);
        }
        int[] dw = new int[ew.length];
        dw[0] = ew[0];
        dw[1] = ew[1];
        dw[2] = ew[2];
        dw[3] = ew[3];
        dw[roundsx4] = ew[roundsx4];
        dw[roundsx4 + 1] = ew[roundsx4 + 1];
        dw[roundsx4 + 2] = ew[roundsx4 + 2];
        dw[roundsx4 + 3] = ew[roundsx4 + 3];
        for (int i = 4; i < roundsx4; ++i) {
            dw[i] = EncryptionAesFastEngineGeneral_NonJava.inv_mcol(ew[i]);
        }
        return new AesKey1D(rounds, ew, dw);
    }

    public void loadIv(byte[] bytes) {
        this.unpackBlockStore1(bytes, 0);
    }

    public void processBlockEncryption(byte[] in, int inOff, byte[] out, int outOff) {
        this.unpackBlock(in, inOff);
        this.xorBlockByBlockStore1();
        this.encryptBlock();
        this.putBlockInBlockStore1();
        this.packBlock(out, outOff);
    }

    public void processBlockDecryption(byte[] in, int inOff, byte[] out, int outOff) {
        this.unpackBlock(in, inOff);
        this.putBlockInBlockStore2();
        this.decryptBlock();
        this.xorBlockByBlockStore1();
        this.putBlockStore2InBlockStore1();
        this.packBlock(out, outOff);
    }

    private void unpackBlock(byte[] bytes, int off) {
        this.C0 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(bytes, off);
        this.C1 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(bytes, off + 4);
        this.C2 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(bytes, off + 8);
        this.C3 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(bytes, off + 12);
    }

    private void unpackBlockStore1(byte[] bytes, int off) {
        this.C0store1 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(bytes, off);
        this.C1store1 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(bytes, off + 4);
        this.C2store1 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(bytes, off + 8);
        this.C3store1 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(bytes, off + 12);
    }

    private void packBlock(byte[] bytes, int off) {
        EncryptionAesFastEngineGeneral_NonJava.intToLittleEndian(this.C0, bytes, off);
        EncryptionAesFastEngineGeneral_NonJava.intToLittleEndian(this.C1, bytes, off + 4);
        EncryptionAesFastEngineGeneral_NonJava.intToLittleEndian(this.C2, bytes, off + 8);
        EncryptionAesFastEngineGeneral_NonJava.intToLittleEndian(this.C3, bytes, off + 12);
    }

    private void putBlockInBlockStore1() {
        this.C0store1 = this.C0;
        this.C1store1 = this.C1;
        this.C2store1 = this.C2;
        this.C3store1 = this.C3;
    }

    private void putBlockInBlockStore2() {
        this.C0store2 = this.C0;
        this.C1store2 = this.C1;
        this.C2store2 = this.C2;
        this.C3store2 = this.C3;
    }

    private void putBlockStore2InBlockStore1() {
        this.C0store1 = this.C0store2;
        this.C1store1 = this.C1store2;
        this.C2store1 = this.C2store2;
        this.C3store1 = this.C3store2;
    }

    private void xorBlockByBlockStore1() {
        this.C0 ^= this.C0store1;
        this.C1 ^= this.C1store1;
        this.C2 ^= this.C2store1;
        this.C3 ^= this.C3store1;
    }

    private void encryptBlock() {
        int r2;
        int r1;
        int r0;
        int i3;
        int i2;
        int i1;
        int i0;
        int t0 = this.C0 ^ this.EW[0];
        int t1 = this.C1 ^ this.EW[1];
        int t2 = this.C2 ^ this.EW[2];
        int r = 1;
        int rx = 4;
        int r3 = this.C3 ^ this.EW[3];
        while (r < this.ROUNDS - 1) {
            i0 = t0;
            i1 = EncryptionAesFastEngine1D_NonJava.s(t1, 8);
            i2 = EncryptionAesFastEngine1D_NonJava.s(t2, 16);
            i3 = EncryptionAesFastEngine1D_NonJava.s(r3, 24);
            r0 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[rx];
            i0 = t1;
            i1 = EncryptionAesFastEngine1D_NonJava.s(t2, 8);
            i2 = EncryptionAesFastEngine1D_NonJava.s(r3, 16);
            i3 = EncryptionAesFastEngine1D_NonJava.s(t0, 24);
            r1 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[rx + 1];
            i0 = t2;
            i1 = EncryptionAesFastEngine1D_NonJava.s(r3, 8);
            i2 = EncryptionAesFastEngine1D_NonJava.s(t0, 16);
            i3 = EncryptionAesFastEngine1D_NonJava.s(t1, 24);
            r2 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[rx + 2];
            i0 = r3;
            i1 = EncryptionAesFastEngine1D_NonJava.s(t0, 8);
            i2 = EncryptionAesFastEngine1D_NonJava.s(t1, 16);
            i3 = EncryptionAesFastEngine1D_NonJava.s(t2, 24);
            r3 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[rx + 3];
            ++r;
            i0 = r0;
            i1 = EncryptionAesFastEngine1D_NonJava.s(r1, 8);
            i2 = EncryptionAesFastEngine1D_NonJava.s(r2, 16);
            i3 = EncryptionAesFastEngine1D_NonJava.s(r3, 24);
            t0 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[rx += 4];
            i0 = r1;
            i1 = EncryptionAesFastEngine1D_NonJava.s(r2, 8);
            i2 = EncryptionAesFastEngine1D_NonJava.s(r3, 16);
            i3 = EncryptionAesFastEngine1D_NonJava.s(r0, 24);
            t1 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[rx + 1];
            i0 = r2;
            i1 = EncryptionAesFastEngine1D_NonJava.s(r3, 8);
            i2 = EncryptionAesFastEngine1D_NonJava.s(r0, 16);
            i3 = EncryptionAesFastEngine1D_NonJava.s(r1, 24);
            t2 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[rx + 2];
            i0 = r3;
            i1 = EncryptionAesFastEngine1D_NonJava.s(r0, 8);
            i2 = EncryptionAesFastEngine1D_NonJava.s(r1, 16);
            i3 = EncryptionAesFastEngine1D_NonJava.s(r2, 24);
            r3 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[rx + 3];
            ++r;
            rx += 4;
        }
        i0 = t0;
        i1 = EncryptionAesFastEngine1D_NonJava.s(t1, 8);
        i2 = EncryptionAesFastEngine1D_NonJava.s(t2, 16);
        i3 = EncryptionAesFastEngine1D_NonJava.s(r3, 24);
        r0 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[rx];
        i0 = t1;
        i1 = EncryptionAesFastEngine1D_NonJava.s(t2, 8);
        i2 = EncryptionAesFastEngine1D_NonJava.s(r3, 16);
        i3 = EncryptionAesFastEngine1D_NonJava.s(t0, 24);
        r1 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[rx + 1];
        i0 = t2;
        i1 = EncryptionAesFastEngine1D_NonJava.s(r3, 8);
        i2 = EncryptionAesFastEngine1D_NonJava.s(t0, 16);
        i3 = EncryptionAesFastEngine1D_NonJava.s(t1, 24);
        r2 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[rx + 2];
        i0 = r3;
        i1 = EncryptionAesFastEngine1D_NonJava.s(t0, 8);
        i2 = EncryptionAesFastEngine1D_NonJava.s(t1, 16);
        i3 = EncryptionAesFastEngine1D_NonJava.s(t2, 24);
        r3 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[rx + 3];
        rx += 4;
        i0 = r0;
        i1 = EncryptionAesFastEngine1D_NonJava.s(r1, 8);
        i2 = EncryptionAesFastEngine1D_NonJava.s(r2, 16);
        i3 = EncryptionAesFastEngine1D_NonJava.s(r3, 24);
        i0 = EncryptionAesFastEngineGeneral_NonJava.S[i0 & 0xFF] & 0xFF;
        i1 = EncryptionAesFastEngineGeneral_NonJava.S[i1 & 0xFF] & 0xFF;
        i2 = EncryptionAesFastEngineGeneral_NonJava.S[i2 & 0xFF] & 0xFF;
        i3 = EncryptionAesFastEngineGeneral_NonJava.S[i3 & 0xFF] & 0xFF;
        this.C0 = i0 ^ i1 << 8 ^ i2 << 16 ^ i3 << 24 ^ this.EW[rx];
        i0 = r1;
        i1 = EncryptionAesFastEngine1D_NonJava.s(r2, 8);
        i2 = EncryptionAesFastEngine1D_NonJava.s(r3, 16);
        i3 = EncryptionAesFastEngine1D_NonJava.s(r0, 24);
        i0 = EncryptionAesFastEngineGeneral_NonJava.S[i0 & 0xFF] & 0xFF;
        i1 = EncryptionAesFastEngineGeneral_NonJava.S[i1 & 0xFF] & 0xFF;
        i2 = EncryptionAesFastEngineGeneral_NonJava.S[i2 & 0xFF] & 0xFF;
        i3 = EncryptionAesFastEngineGeneral_NonJava.S[i3 & 0xFF] & 0xFF;
        this.C1 = i0 ^ i1 << 8 ^ i2 << 16 ^ i3 << 24 ^ this.EW[rx + 1];
        i0 = r2;
        i1 = EncryptionAesFastEngine1D_NonJava.s(r3, 8);
        i2 = EncryptionAesFastEngine1D_NonJava.s(r0, 16);
        i3 = EncryptionAesFastEngine1D_NonJava.s(r1, 24);
        i0 = EncryptionAesFastEngineGeneral_NonJava.S[i0 & 0xFF] & 0xFF;
        i1 = EncryptionAesFastEngineGeneral_NonJava.S[i1 & 0xFF] & 0xFF;
        i2 = EncryptionAesFastEngineGeneral_NonJava.S[i2 & 0xFF] & 0xFF;
        i3 = EncryptionAesFastEngineGeneral_NonJava.S[i3 & 0xFF] & 0xFF;
        this.C2 = i0 ^ i1 << 8 ^ i2 << 16 ^ i3 << 24 ^ this.EW[rx + 2];
        i0 = r3;
        i1 = EncryptionAesFastEngine1D_NonJava.s(r0, 8);
        i2 = EncryptionAesFastEngine1D_NonJava.s(r1, 16);
        i3 = EncryptionAesFastEngine1D_NonJava.s(r2, 24);
        i0 = EncryptionAesFastEngineGeneral_NonJava.S[i0 & 0xFF] & 0xFF;
        i1 = EncryptionAesFastEngineGeneral_NonJava.S[i1 & 0xFF] & 0xFF;
        i2 = EncryptionAesFastEngineGeneral_NonJava.S[i2 & 0xFF] & 0xFF;
        i3 = EncryptionAesFastEngineGeneral_NonJava.S[i3 & 0xFF] & 0xFF;
        this.C3 = i0 ^ i1 << 8 ^ i2 << 16 ^ i3 << 24 ^ this.EW[rx + 3];
    }

    private void decryptBlock() {
        int r2;
        int r1;
        int r0;
        int i3;
        int i2;
        int i1;
        int i0;
        int ROUNDSx4 = this.ROUNDS * 4;
        int t0 = this.C0 ^ this.DW[ROUNDSx4];
        int t1 = this.C1 ^ this.DW[ROUNDSx4 + 1];
        int t2 = this.C2 ^ this.DW[ROUNDSx4 + 2];
        int r = this.ROUNDS - 1;
        int rx = ROUNDSx4 - 4;
        int r3 = this.C3 ^ this.DW[ROUNDSx4 + 3];
        while (r > 1) {
            i0 = t0;
            i1 = EncryptionAesFastEngine1D_NonJava.s(r3, 8);
            i2 = EncryptionAesFastEngine1D_NonJava.s(t2, 16);
            i3 = EncryptionAesFastEngine1D_NonJava.s(t1, 24);
            r0 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[rx];
            i0 = t1;
            i1 = EncryptionAesFastEngine1D_NonJava.s(t0, 8);
            i2 = EncryptionAesFastEngine1D_NonJava.s(r3, 16);
            i3 = EncryptionAesFastEngine1D_NonJava.s(t2, 24);
            r1 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[rx + 1];
            i0 = t2;
            i1 = EncryptionAesFastEngine1D_NonJava.s(t1, 8);
            i2 = EncryptionAesFastEngine1D_NonJava.s(t0, 16);
            i3 = EncryptionAesFastEngine1D_NonJava.s(r3, 24);
            r2 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[rx + 2];
            i0 = r3;
            i1 = EncryptionAesFastEngine1D_NonJava.s(t2, 8);
            i2 = EncryptionAesFastEngine1D_NonJava.s(t1, 16);
            i3 = EncryptionAesFastEngine1D_NonJava.s(t0, 24);
            r3 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[rx + 3];
            --r;
            i0 = r0;
            i1 = EncryptionAesFastEngine1D_NonJava.s(r3, 8);
            i2 = EncryptionAesFastEngine1D_NonJava.s(r2, 16);
            i3 = EncryptionAesFastEngine1D_NonJava.s(r1, 24);
            t0 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[rx -= 4];
            i0 = r1;
            i1 = EncryptionAesFastEngine1D_NonJava.s(r0, 8);
            i2 = EncryptionAesFastEngine1D_NonJava.s(r3, 16);
            i3 = EncryptionAesFastEngine1D_NonJava.s(r2, 24);
            t1 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[rx + 1];
            i0 = r2;
            i1 = EncryptionAesFastEngine1D_NonJava.s(r1, 8);
            i2 = EncryptionAesFastEngine1D_NonJava.s(r0, 16);
            i3 = EncryptionAesFastEngine1D_NonJava.s(r3, 24);
            t2 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[rx + 2];
            i0 = r3;
            i1 = EncryptionAesFastEngine1D_NonJava.s(r2, 8);
            i2 = EncryptionAesFastEngine1D_NonJava.s(r1, 16);
            i3 = EncryptionAesFastEngine1D_NonJava.s(r0, 24);
            r3 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[rx + 3];
            --r;
            rx -= 4;
        }
        i0 = t0;
        i1 = EncryptionAesFastEngine1D_NonJava.s(r3, 8);
        i2 = EncryptionAesFastEngine1D_NonJava.s(t2, 16);
        i3 = EncryptionAesFastEngine1D_NonJava.s(t1, 24);
        r0 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[4];
        i0 = t1;
        i1 = EncryptionAesFastEngine1D_NonJava.s(t0, 8);
        i2 = EncryptionAesFastEngine1D_NonJava.s(r3, 16);
        i3 = EncryptionAesFastEngine1D_NonJava.s(t2, 24);
        r1 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[5];
        i0 = t2;
        i1 = EncryptionAesFastEngine1D_NonJava.s(t1, 8);
        i2 = EncryptionAesFastEngine1D_NonJava.s(t0, 16);
        i3 = EncryptionAesFastEngine1D_NonJava.s(r3, 24);
        r2 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[6];
        i0 = r3;
        i1 = EncryptionAesFastEngine1D_NonJava.s(t2, 8);
        i2 = EncryptionAesFastEngine1D_NonJava.s(t1, 16);
        i3 = EncryptionAesFastEngine1D_NonJava.s(t0, 24);
        r3 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[7];
        i0 = r0;
        i1 = EncryptionAesFastEngine1D_NonJava.s(r3, 8);
        i2 = EncryptionAesFastEngine1D_NonJava.s(r2, 16);
        i3 = EncryptionAesFastEngine1D_NonJava.s(r1, 24);
        i0 = EncryptionAesFastEngineGeneral_NonJava.Si[i0 & 0xFF] & 0xFF;
        i1 = EncryptionAesFastEngineGeneral_NonJava.Si[i1 & 0xFF] & 0xFF;
        i2 = EncryptionAesFastEngineGeneral_NonJava.Si[i2 & 0xFF] & 0xFF;
        i3 = EncryptionAesFastEngineGeneral_NonJava.Si[i3 & 0xFF] & 0xFF;
        this.C0 = i0 ^ i1 << 8 ^ i2 << 16 ^ i3 << 24 ^ this.DW[0];
        i0 = r1;
        i1 = EncryptionAesFastEngine1D_NonJava.s(r0, 8);
        i2 = EncryptionAesFastEngine1D_NonJava.s(r3, 16);
        i3 = EncryptionAesFastEngine1D_NonJava.s(r2, 24);
        i0 = EncryptionAesFastEngineGeneral_NonJava.Si[i0 & 0xFF] & 0xFF;
        i1 = EncryptionAesFastEngineGeneral_NonJava.Si[i1 & 0xFF] & 0xFF;
        i2 = EncryptionAesFastEngineGeneral_NonJava.Si[i2 & 0xFF] & 0xFF;
        i3 = EncryptionAesFastEngineGeneral_NonJava.Si[i3 & 0xFF] & 0xFF;
        this.C1 = i0 ^ i1 << 8 ^ i2 << 16 ^ i3 << 24 ^ this.DW[1];
        i0 = r2;
        i1 = EncryptionAesFastEngine1D_NonJava.s(r1, 8);
        i2 = EncryptionAesFastEngine1D_NonJava.s(r0, 16);
        i3 = EncryptionAesFastEngine1D_NonJava.s(r3, 24);
        i0 = EncryptionAesFastEngineGeneral_NonJava.Si[i0 & 0xFF] & 0xFF;
        i1 = EncryptionAesFastEngineGeneral_NonJava.Si[i1 & 0xFF] & 0xFF;
        i2 = EncryptionAesFastEngineGeneral_NonJava.Si[i2 & 0xFF] & 0xFF;
        i3 = EncryptionAesFastEngineGeneral_NonJava.Si[i3 & 0xFF] & 0xFF;
        this.C2 = i0 ^ i1 << 8 ^ i2 << 16 ^ i3 << 24 ^ this.DW[2];
        i0 = r3;
        i1 = EncryptionAesFastEngine1D_NonJava.s(r2, 8);
        i2 = EncryptionAesFastEngine1D_NonJava.s(r1, 16);
        i3 = EncryptionAesFastEngine1D_NonJava.s(r0, 24);
        i0 = EncryptionAesFastEngineGeneral_NonJava.Si[i0 & 0xFF] & 0xFF;
        i1 = EncryptionAesFastEngineGeneral_NonJava.Si[i1 & 0xFF] & 0xFF;
        i2 = EncryptionAesFastEngineGeneral_NonJava.Si[i2 & 0xFF] & 0xFF;
        i3 = EncryptionAesFastEngineGeneral_NonJava.Si[i3 & 0xFF] & 0xFF;
        this.C3 = i0 ^ i1 << 8 ^ i2 << 16 ^ i3 << 24 ^ this.DW[3];
    }
}

