/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.bytedata.reader;

import java.nio.ByteBuffer;
import lowentry.ue4.classes.SimpleByteDataReader;
import lowentry.ue4.library.LowEntry;

public class SimpleByteBufferDataReader
extends SimpleByteDataReader {
    protected final ByteBuffer bytes;
    protected final int subLength;

    public SimpleByteBufferDataReader(ByteBuffer bytes) {
        this.bytes = bytes;
        this.subLength = bytes == null ? 0 : bytes.remaining();
    }

    public SimpleByteBufferDataReader(ByteBuffer bytes, int length) {
        this.bytes = bytes;
        this.subLength = bytes == null || length < 0 ? 0 : length;
    }

    protected SimpleByteBufferDataReader(ByteBuffer bytes, int subLength, int position) {
        this.bytes = bytes;
        this.subLength = subLength;
        this.position = position;
    }

    @Override
    public SimpleByteBufferDataReader getClone() {
        return new SimpleByteBufferDataReader(this.bytes, this.subLength, this.position);
    }

    @Override
    protected int getTotalCountImplementation() {
        return this.subLength;
    }

    @Override
    public byte getByteImplementation(int index) {
        return this.bytes.get(index);
    }

    @Override
    protected String getStringUtf8Implementation(int index, int length) {
        if (this.bytes.hasArray()) {
            return LowEntry.bytesToStringUtf8(this.bytes.array(), this.bytes.arrayOffset() + index, length);
        }
        byte[] b = new byte[length];
        this.bytes.get(b, index, length);
        return LowEntry.bytesToStringUtf8(b);
    }

    @Override
    protected String getStringLatin1Implementation(int index, int length) {
        if (this.bytes.hasArray()) {
            return LowEntry.bytesToStringLatin1(this.bytes.array(), this.bytes.arrayOffset() + index, length);
        }
        byte[] b = new byte[length];
        this.bytes.get(b, index, length);
        return LowEntry.bytesToStringLatin1(b);
    }

    @Override
    protected byte[] getByteArrayImplementation(int index, int length) {
        if (this.bytes.hasArray()) {
            return LowEntry.bytesSubArray(this.bytes.array(), this.bytes.arrayOffset() + index, length);
        }
        byte[] b = new byte[length];
        this.bytes.get(b, index, length);
        return b;
    }
}

