/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes;

import java.util.Collection;
import lowentry.ue4.classes.ByteDataWriter;

public abstract class SimpleByteDataWriter
extends ByteDataWriter {
    @Override
    protected void addUinteger(int value) {
        if (value < 0) {
            value = 0;
        }
        this.addingUnsafe(4);
        this.addRawByteUnsafe((byte)(value >> 24));
        this.addRawByteUnsafe((byte)(value >> 16));
        this.addRawByteUnsafe((byte)(value >> 8));
        this.addRawByteUnsafe((byte)value);
    }

    @Override
    protected void addUintegerUnsafe(int value) {
        if (value < 0) {
            value = 0;
        }
        this.addRawByteUnsafe((byte)(value >> 24));
        this.addRawByteUnsafe((byte)(value >> 16));
        this.addRawByteUnsafe((byte)(value >> 8));
        this.addRawByteUnsafe((byte)value);
    }

    @Override
    public SimpleByteDataWriter addBooleanArray(boolean[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (boolean v : value) {
            this.addBoolean(v);
        }
        return this;
    }

    @Override
    public SimpleByteDataWriter addBooleanArray(Boolean[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        Boolean[] booleanArray = value;
        int n = booleanArray.length;
        for (int i = 0; i < n; ++i) {
            boolean v = booleanArray[i];
            this.addBoolean(v);
        }
        return this;
    }

    @Override
    public SimpleByteDataWriter addBooleanArray(Collection<Boolean> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (boolean v : value) {
            this.addBoolean(v);
        }
        return this;
    }
}

