/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes;

public abstract class ByteDataReader {
    protected int position = 0;

    public abstract ByteDataReader getClone();

    protected abstract int getTotalCountImplementation();

    protected abstract byte getByteImplementation(int var1);

    public int position() {
        return this.position;
    }

    public ByteDataReader position(int position) {
        this.position = Math.max(0, position);
        return this;
    }

    public ByteDataReader reset() {
        this.position = 0;
        return this;
    }

    public ByteDataReader empty() {
        this.position = this.getTotalCountImplementation();
        return this;
    }

    protected int getAndIncreasePosition(int increasement) {
        int count = this.getTotalCountImplementation();
        int pos = this.position;
        this.position = count - increasement <= this.position ? count : (this.position += increasement);
        return pos;
    }

    public int remaining() {
        return this.getTotalCountImplementation() - this.position;
    }

    protected int maxElementsRemaining(int minimumSizePerElement) {
        int remaining = this.remaining();
        if (remaining <= 0) {
            return 0;
        }
        if (minimumSizePerElement <= 1) {
            return remaining;
        }
        return remaining / minimumSizePerElement + 1;
    }

    protected int getUinteger() {
        int pos;
        int count = this.getTotalCountImplementation();
        if (count <= (pos = this.getAndIncreasePosition(1))) {
            return 0;
        }
        byte b = this.getByteImplementation(pos);
        if ((b >> 7 & 1) == 0) {
            return b & 0xFF;
        }
        pos = this.getAndIncreasePosition(3);
        if (count <= pos + 2) {
            return 0;
        }
        int value = (b & 0xFF & 0xFFFFFF7F) << 24 | (this.getByteImplementation(pos) & 0xFF) << 16 | (this.getByteImplementation(pos + 1) & 0xFF) << 8 | this.getByteImplementation(pos + 2) & 0xFF;
        if (value < 128) {
            return 0;
        }
        return value;
    }

    public byte getByte() {
        int pos = this.getAndIncreasePosition(1);
        if (this.getTotalCountImplementation() <= pos) {
            return 0;
        }
        return this.getByteImplementation(pos);
    }

    public int getInteger() {
        int pos;
        int count = this.getTotalCountImplementation();
        if (count <= (pos = this.getAndIncreasePosition(4))) {
            return 0;
        }
        if (count <= pos + 1) {
            return this.getByteImplementation(pos) & 0xFF;
        }
        if (count <= pos + 2) {
            return (this.getByteImplementation(pos) & 0xFF) << 8 | this.getByteImplementation(pos + 1) & 0xFF;
        }
        if (count <= pos + 3) {
            return (this.getByteImplementation(pos) & 0xFF) << 16 | (this.getByteImplementation(pos + 1) & 0xFF) << 8 | this.getByteImplementation(pos + 2) & 0xFF;
        }
        return (this.getByteImplementation(pos) & 0xFF) << 24 | (this.getByteImplementation(pos + 1) & 0xFF) << 16 | (this.getByteImplementation(pos + 2) & 0xFF) << 8 | this.getByteImplementation(pos + 3) & 0xFF;
    }

    public int getPositiveInteger1() {
        int pos;
        int count = this.getTotalCountImplementation();
        if (count <= (pos = this.getAndIncreasePosition(1))) {
            return 0;
        }
        byte b = this.getByteImplementation(pos);
        if ((b >> 7 & 1) == 0) {
            return b & 0xFF;
        }
        pos = this.getAndIncreasePosition(3);
        if (count <= pos + 2) {
            return 0;
        }
        int value = (b & 0xFF & 0xFFFFFF7F) << 24 | (this.getByteImplementation(pos) & 0xFF) << 16 | (this.getByteImplementation(pos + 1) & 0xFF) << 8 | this.getByteImplementation(pos + 2) & 0xFF;
        if (value < 128) {
            return 0;
        }
        return value;
    }

    public int getPositiveInteger2() {
        int pos;
        int count = this.getTotalCountImplementation();
        if (count <= (pos = this.getAndIncreasePosition(2)) + 1) {
            return 0;
        }
        byte b1 = this.getByteImplementation(pos);
        byte b2 = this.getByteImplementation(pos + 1);
        if ((b1 >> 7 & 1) == 0) {
            return (b1 & 0xFF) << 8 | b2 & 0xFF;
        }
        pos = this.getAndIncreasePosition(2);
        if (count <= pos + 1) {
            return 0;
        }
        int value = (b1 & 0xFF & 0xFFFFFF7F) << 24 | (b2 & 0xFF) << 16 | (this.getByteImplementation(pos) & 0xFF) << 8 | this.getByteImplementation(pos + 1) & 0xFF;
        if (value < 32768) {
            return 0;
        }
        return value;
    }

    public int getPositiveInteger3() {
        int pos;
        int count = this.getTotalCountImplementation();
        if (count <= (pos = this.getAndIncreasePosition(3)) + 2) {
            return 0;
        }
        byte b1 = this.getByteImplementation(pos);
        byte b2 = this.getByteImplementation(pos + 1);
        byte b3 = this.getByteImplementation(pos + 2);
        if ((b1 >> 7 & 1) == 0) {
            return (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
        }
        pos = this.getAndIncreasePosition(1);
        if (count <= pos) {
            return 0;
        }
        int value = (b1 & 0xFF & 0xFFFFFF7F) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | this.getByteImplementation(pos) & 0xFF;
        if (value < 0x800000) {
            return 0;
        }
        return value;
    }

    public long getLong() {
        int pos;
        int count = this.getTotalCountImplementation();
        if (count <= (pos = this.getAndIncreasePosition(8))) {
            return 0L;
        }
        if (count <= pos + 1) {
            return (long)this.getByteImplementation(pos) & 0xFFL;
        }
        if (count <= pos + 2) {
            return ((long)this.getByteImplementation(pos) & 0xFFL) << 8 | (long)this.getByteImplementation(pos + 1) & 0xFFL;
        }
        if (count <= pos + 3) {
            return ((long)this.getByteImplementation(pos) & 0xFFL) << 16 | ((long)this.getByteImplementation(pos + 1) & 0xFFL) << 8 | (long)this.getByteImplementation(pos + 2) & 0xFFL;
        }
        if (count <= pos + 4) {
            return ((long)this.getByteImplementation(pos) & 0xFFL) << 24 | ((long)this.getByteImplementation(pos + 1) & 0xFFL) << 16 | ((long)this.getByteImplementation(pos + 2) & 0xFFL) << 8 | (long)this.getByteImplementation(pos + 3) & 0xFFL;
        }
        if (count <= pos + 5) {
            return ((long)this.getByteImplementation(pos) & 0xFFL) << 32 | ((long)this.getByteImplementation(pos + 1) & 0xFFL) << 24 | ((long)this.getByteImplementation(pos + 2) & 0xFFL) << 16 | ((long)this.getByteImplementation(pos + 3) & 0xFFL) << 8 | (long)this.getByteImplementation(pos + 4) & 0xFFL;
        }
        if (count <= pos + 6) {
            return ((long)this.getByteImplementation(pos) & 0xFFL) << 40 | ((long)this.getByteImplementation(pos + 1) & 0xFFL) << 32 | ((long)this.getByteImplementation(pos + 2) & 0xFFL) << 24 | ((long)this.getByteImplementation(pos + 3) & 0xFFL) << 16 | ((long)this.getByteImplementation(pos + 4) & 0xFFL) << 8 | (long)this.getByteImplementation(pos + 5) & 0xFFL;
        }
        if (count <= pos + 7) {
            return ((long)this.getByteImplementation(pos) & 0xFFL) << 48 | ((long)this.getByteImplementation(pos + 1) & 0xFFL) << 40 | ((long)this.getByteImplementation(pos + 2) & 0xFFL) << 32 | ((long)this.getByteImplementation(pos + 3) & 0xFFL) << 24 | ((long)this.getByteImplementation(pos + 4) & 0xFFL) << 16 | ((long)this.getByteImplementation(pos + 5) & 0xFFL) << 8 | (long)this.getByteImplementation(pos + 6) & 0xFFL;
        }
        return ((long)this.getByteImplementation(pos) & 0xFFL) << 56 | ((long)this.getByteImplementation(pos + 1) & 0xFFL) << 48 | ((long)this.getByteImplementation(pos + 2) & 0xFFL) << 40 | ((long)this.getByteImplementation(pos + 3) & 0xFFL) << 32 | ((long)this.getByteImplementation(pos + 4) & 0xFFL) << 24 | ((long)this.getByteImplementation(pos + 5) & 0xFFL) << 16 | ((long)this.getByteImplementation(pos + 6) & 0xFFL) << 8 | (long)this.getByteImplementation(pos + 7) & 0xFFL;
    }

    public float getFloat() {
        return Float.intBitsToFloat(this.getInteger());
    }

    public double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    public boolean getBoolean() {
        int pos = this.getAndIncreasePosition(1);
        if (this.getTotalCountImplementation() <= pos) {
            return false;
        }
        return this.getByteImplementation(pos) == 1;
    }

    public String getStringUtf8() {
        int count = this.getTotalCountImplementation();
        int length = this.getUinteger();
        if (length <= 0) {
            return "";
        }
        int pos = this.getAndIncreasePosition(length);
        if (count <= pos) {
            return "";
        }
        int maxLength = count - pos;
        if (length > maxLength) {
            length = maxLength;
        }
        return this.getStringUtf8Implementation(pos, length);
    }

    protected abstract String getStringUtf8Implementation(int var1, int var2);

    public String getStringLatin1() {
        int count = this.getTotalCountImplementation();
        int length = this.getUinteger();
        if (length <= 0) {
            return "";
        }
        int pos = this.getAndIncreasePosition(length);
        if (count <= pos) {
            return "";
        }
        int maxLength = count - pos;
        if (length > maxLength) {
            length = maxLength;
        }
        return this.getStringLatin1Implementation(pos, length);
    }

    protected abstract String getStringLatin1Implementation(int var1, int var2);

    public byte[] getByteArray() {
        int count = this.getTotalCountImplementation();
        int length = this.getUinteger();
        if (length <= 0) {
            return new byte[0];
        }
        int pos = this.getAndIncreasePosition(length);
        if (count <= pos) {
            return new byte[0];
        }
        int maxLength = count - pos;
        if (length > maxLength) {
            length = maxLength;
        }
        return this.getByteArrayImplementation(pos, length);
    }

    protected abstract byte[] getByteArrayImplementation(int var1, int var2);

    public int[] getIntegerArray() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(4))) <= 0) {
            return new int[0];
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getInteger();
        }
        return array;
    }

    public int[] getPositiveInteger1Array() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(1))) <= 0) {
            return new int[0];
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getPositiveInteger1();
        }
        return array;
    }

    public int[] getPositiveInteger2Array() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(2))) <= 0) {
            return new int[0];
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getPositiveInteger2();
        }
        return array;
    }

    public int[] getPositiveInteger3Array() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(3))) <= 0) {
            return new int[0];
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getPositiveInteger3();
        }
        return array;
    }

    public long[] getLongArray() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(8))) <= 0) {
            return new long[0];
        }
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getLong();
        }
        return array;
    }

    public float[] getFloatArray() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(4))) <= 0) {
            return new float[0];
        }
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getFloat();
        }
        return array;
    }

    public double[] getDoubleArray() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(8))) <= 0) {
            return new double[0];
        }
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getDouble();
        }
        return array;
    }

    public boolean[] getBooleanArray() {
        int length = this.getUinteger();
        if ((length = Math.min(length, ByteDataReader.safeMultiply(this.maxElementsRemaining(1), 8))) <= 0) {
            return new boolean[0];
        }
        boolean[] array = new boolean[length];
        for (int i = 0; i < length; i += 8) {
            byte b = this.getByte();
            for (int bIndex = 0; bIndex < 8; ++bIndex) {
                int index = i + bIndex;
                if (index >= length) {
                    return array;
                }
                array[index] = (b >> 7 - bIndex & 1) != 0;
            }
        }
        return array;
    }

    public String[] getStringUtf8Array() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(1))) <= 0) {
            return new String[0];
        }
        String[] array = new String[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getStringUtf8();
        }
        return array;
    }

    public String[] getStringLatin1Array() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(1))) <= 0) {
            return new String[0];
        }
        String[] array = new String[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getStringLatin1();
        }
        return array;
    }

    protected static int safeMultiply(int a, int b) {
        long result = (long)a * (long)b;
        if (result > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (result < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)result;
    }
}

