/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.http;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lowentry.ue4.classes.http.HttpClient;
import lowentry.ue4.classes.http.HttpRequest;
import lowentry.ue4.classes.http.HttpServer;
import lowentry.ue4.library.LowEntry;
import lowentry.ue4.libs.jackson.databind.JsonNode;

public class HttpResponse {
    protected final HttpClient client;
    protected final HttpRequest request;
    protected volatile int responseCode = 200;
    protected final HashMap<String, String> headers = new HashMap();
    protected final ByteArrayOutputStream content = new ByteArrayOutputStream();

    public HttpResponse(HttpClient client, HttpRequest request) {
        this.client = client;
        this.request = request;
        this.setContentIsHtml();
    }

    public int getReponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeader(String header) {
        HashMap<String, String> hashMap = this.headers;
        synchronized (hashMap) {
            return this.headers.get(header.trim().toLowerCase(Locale.ENGLISH));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(String header, String value) {
        HashMap<String, String> hashMap = this.headers;
        synchronized (hashMap) {
            if (value == null) {
                this.headers.remove(header.trim().toLowerCase(Locale.ENGLISH));
            } else {
                this.headers.put(header.trim().toLowerCase(Locale.ENGLISH), value.trim());
            }
        }
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public void setContentType(String type) {
        this.setHeader("content-type", type);
    }

    public void setContentIsHtml() {
        this.setContentType("text/html; charset=utf-8");
    }

    public void setContentIsPlainText() {
        this.setContentType("text/plain; charset=utf-8");
    }

    public void setContentIsJson() {
        this.setContentType("application/json; charset=utf-8");
    }

    public void addContent(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return;
        }
        try {
            this.content.write(bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addContent(String text) {
        if (text == null || text.length() <= 0) {
            return;
        }
        try {
            this.content.write(LowEntry.stringToBytesUtf8(text));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setContentAsJson(Object object) {
        this.setContentIsJson();
        this.clearContent();
        this.addContent(LowEntry.toJsonString(object));
    }

    public void clearContent() {
        this.content.reset();
    }

    public byte[] getContentAsBytes() {
        return this.content.toByteArray();
    }

    public String getContentAsString() {
        return LowEntry.bytesToStringUtf8(this.content.toByteArray());
    }

    public JsonNode getContentAsJson() {
        String contentAsString = this.getContentAsString();
        if (contentAsString == null || contentAsString.length() <= 0) {
            return null;
        }
        return LowEntry.parseJsonString(contentAsString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("HTTP/1.1 ");
        buffer.append(this.responseCode);
        buffer.append("\r\n");
        HashMap<String, String> hashMap = this.headers;
        synchronized (hashMap) {
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                buffer.append(header.getKey());
                buffer.append(":");
                buffer.append(header.getValue());
                buffer.append("\r\n");
            }
        }
        byte[] contentBytes = this.content.toByteArray();
        buffer.append("content-length:");
        buffer.append(contentBytes.length);
        buffer.append("\r\n");
        buffer.append("date:");
        buffer.append(HttpServer.internal_getServerTime());
        buffer.append("\r\n");
        buffer.append("connection:close\r\n");
        buffer.append("\r\n");
        byte[] header = LowEntry.stringToBytesLatin1(buffer.toString());
        if (this.request.isMethod("HEAD")) {
            return header;
        }
        return LowEntry.mergeBytes(header, contentBytes);
    }

    public void done() {
        if (this.client.isConnected()) {
            this.client.send(this.toBytes());
        }
    }
}

