/*
 * Decompiled with CFR 0.152.
 */
package com.spacenetwork.flatsat;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.entities.comm.CommAdapter;
import com.snaju.nebula.entities.socket.udp.NebulaUDPListener;
import com.spacenetwork.mcs.entites.comm.obj.SNPacket;
import com.spacenetwork.mcs.services.RedisService;
import fr.devnied.bitlib.BytesUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.function.BiConsumer;
import javax.inject.Singleton;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

@Singleton
public class FlatSatCommAdapter
extends CommAdapter<SNPacket> {
    private static final String BROKER_URL = "ssl://mqtt-sandbox.leaf.space:8883";
    private static final String USERNAME = "spacenetwork01";
    private static final String PASSWORD = "PfHZ2qTqp86Jklh5rrfXzMObNgPUcNRi";
    private MqttClient client;
    private DatagramSocket udpSocket;
    private NebulaUDPListener listener;
    private final List<BiConsumer<String, byte[]>> downlinkListeners = new ArrayList<BiConsumer<String, byte[]>>();

    public byte[] convertHexToBytes(String input) {
        String[] parts = input.trim().split("\\s+");
        byte[] data = new byte[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.startsWith("0x") || part.startsWith("0X")) {
                part = part.substring(2);
            }
            int val = Integer.parseInt(part, 16);
            data[i] = (byte)val;
        }
        return data;
    }

    public void connect() {
        try {
            this.udpSocket = new DatagramSocket();
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        this.listener = new NebulaUDPListener(this.udpSocket){

            protected void processPacket(byte[] data, InetAddress address, int port) {
                ((RedisService)SpaceSDK.inject(RedisService.class)).getRedisConnection().sync().publish((Object)"flatsat:rx", (Object)Base64.getEncoder().encodeToString(data));
            }
        };
        this.listener.start();
        String clientId = "LeafSpaceClient-" + System.currentTimeMillis();
        try {
            this.client = new MqttClient(BROKER_URL, clientId, null);
        }
        catch (MqttException e) {
            throw new RuntimeException("Failed to initialize MQTT Client", e);
        }
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(true);
        options.setAutomaticReconnect(true);
        options.setUserName(USERNAME);
        options.setPassword(PASSWORD.toCharArray());
        options.setSocketFactory(SSLSocketFactory.getDefault());
        this.client.setCallback(new MqttCallback(){

            public void connectionLost(Throwable cause) {
                System.err.println("\u274c Connection lost: " + cause.getMessage());
            }

            public void messageArrived(String topic, MqttMessage message) {
                byte[] payload = message.getPayload();
                String nPayload = new String(payload);
                JsonObject object = JsonParser.parseString((String)nPayload).getAsJsonObject();
                String payloadJ = object.get("payload").getAsString();
                byte[] bin = FlatSatCommAdapter.this.convertHexToBytes(payloadJ);
                System.out.println("[MQTT]: " + BytesUtils.bytesToString((byte[])bin));
                DatagramPacket packet = null;
                try {
                    packet = new DatagramPacket(bin, bin.length, Inet4Address.getByName("127.0.0.1"), 52002);
                    FlatSatCommAdapter.this.udpSocket.send(packet);
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }
        });
        try {
            System.out.println("\ud83d\udd17 Connecting to LeafSpace MQTT broker...");
            this.client.connect(options);
            System.out.println("\u2705 Connected to ssl://mqtt-sandbox.leaf.space:8883");
            this.client.subscribe("loopback/spacenetwork01/downlink", 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void disconnect() {
        if (this.client != null && this.client.isConnected()) {
            try {
                this.client.disconnect();
                System.out.println("\ud83d\udd0c Disconnected from broker.");
            }
            catch (MqttException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void read() {
    }

    public void write(SNPacket packet) {
    }
}

