/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.MonoFromFluxOperator;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;

final class MonoTakeLastOne<T>
extends MonoFromFluxOperator<T, T>
implements Fuseable {
    final T defaultValue;

    MonoTakeLastOne(Flux<? extends T> source2) {
        super(source2);
        this.defaultValue = null;
    }

    MonoTakeLastOne(Flux<? extends T> source2, T defaultValue) {
        super(source2);
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new TakeLastOneSubscriber<T>(actual, this.defaultValue, true);
    }

    static final class TakeLastOneSubscriber<T>
    extends Operators.MonoSubscriber<T, T> {
        final boolean mustEmit;
        final T defaultValue;
        Subscription s;

        TakeLastOneSubscriber(CoreSubscriber<? super T> actual, @Nullable T defaultValue, boolean mustEmit) {
            super(actual);
            this.defaultValue = defaultValue;
            this.mustEmit = mustEmit;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.validate(this.s, s2)) {
                this.s = s2;
                this.actual.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            return super.scanUnsafe(key);
        }

        @Override
        public void onNext(T t) {
            Object old = this.value;
            this.setValue(t);
            Operators.onDiscard(old, this.actual.currentContext());
        }

        @Override
        public void onComplete() {
            Object v = this.value;
            if (v == null) {
                if (this.mustEmit) {
                    if (this.defaultValue != null) {
                        this.complete(this.defaultValue);
                    } else {
                        this.actual.onError(Operators.onOperatorError(new NoSuchElementException("Flux#last() didn't observe any onNext signal"), this.actual.currentContext()));
                    }
                } else {
                    this.actual.onComplete();
                }
                return;
            }
            this.complete(v);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

