/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Predicate;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.FluxRetryPredicate;
import reactor.core.publisher.InternalMonoOperator;
import reactor.core.publisher.Mono;

final class MonoRetryPredicate<T>
extends InternalMonoOperator<T, T> {
    final Predicate<? super Throwable> predicate;

    MonoRetryPredicate(Mono<? extends T> source2, Predicate<? super Throwable> predicate) {
        super(source2);
        this.predicate = Objects.requireNonNull(predicate, "predicate");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        FluxRetryPredicate.RetryPredicateSubscriber<T> parent = new FluxRetryPredicate.RetryPredicateSubscriber<T>(this.source, actual, this.predicate);
        actual.onSubscribe(parent);
        if (!parent.isCancelled()) {
            parent.resubscribe();
        }
        return null;
    }
}

