/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxPeek;
import reactor.core.publisher.FluxPeekFuseable;
import reactor.core.publisher.InternalMonoOperator;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalPeek;
import reactor.util.annotation.Nullable;

final class MonoPeek<T>
extends InternalMonoOperator<T, T>
implements SignalPeek<T> {
    final Consumer<? super Subscription> onSubscribeCall;
    final Consumer<? super T> onNextCall;
    final LongConsumer onRequestCall;
    final Runnable onCancelCall;

    MonoPeek(Mono<? extends T> source2, @Nullable Consumer<? super Subscription> onSubscribeCall, @Nullable Consumer<? super T> onNextCall, @Nullable LongConsumer onRequestCall, @Nullable Runnable onCancelCall) {
        super(source2);
        this.onSubscribeCall = onSubscribeCall;
        this.onNextCall = onNextCall;
        this.onRequestCall = onRequestCall;
        this.onCancelCall = onCancelCall;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            return new FluxPeekFuseable.PeekConditionalSubscriber((Fuseable.ConditionalSubscriber)actual, this);
        }
        return new FluxPeek.PeekSubscriber<T>(actual, this);
    }

    @Override
    @Nullable
    public Consumer<? super Subscription> onSubscribeCall() {
        return this.onSubscribeCall;
    }

    @Override
    @Nullable
    public Consumer<? super T> onNextCall() {
        return this.onNextCall;
    }

    @Override
    @Nullable
    public Consumer<? super Throwable> onErrorCall() {
        return null;
    }

    @Override
    @Nullable
    public Runnable onCompleteCall() {
        return null;
    }

    @Override
    @Nullable
    public Runnable onAfterTerminateCall() {
        return null;
    }

    @Override
    @Nullable
    public LongConsumer onRequestCall() {
        return this.onRequestCall;
    }

    @Override
    @Nullable
    public Runnable onCancelCall() {
        return this.onCancelCall;
    }
}

