/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon.service;

import com.google.inject.Singleton;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dartnode.mon.entites.service.HiveService;
import net.dartnode.mon.entites.thread.AsyncThread;
import net.dartnode.mon.entites.thread.HiveAsyncThread;
import net.dartnode.mon.entites.thread.ThreadExceptionHandler;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Singleton
public class ThreadService
implements HiveService {
    private ConcurrentHashMap<String, Thread> threads = new ConcurrentHashMap();
    private ExecutorService pool = Executors.newFixedThreadPool(10);

    public Future queueToPool(Runnable runnable2) {
        return this.pool.submit(runnable2);
    }

    public Thread runDedicatedThread(String name, Runnable runnable2) {
        Thread t = new Thread(runnable2);
        t.setName(name);
        t.setUncaughtExceptionHandler(new ThreadExceptionHandler());
        t.start();
        this.threads.put(t.getName(), t);
        System.out.println("+Starting Thread with name " + name + " (" + this.threads.size() + " total)");
        return t;
    }

    public boolean isRunning(String name) {
        if (this.threads.containsKey(name)) {
            return this.threads.get(name).isAlive() && !this.threads.get(name).isInterrupted();
        }
        return false;
    }

    public boolean killThread(String name) {
        if (this.threads.containsKey(name)) {
            this.threads.get(name).interrupt();
            this.threads.remove(name);
            return true;
        }
        return false;
    }

    public int killThreads(String regex) {
        int c = 0;
        Pattern pattern = Pattern.compile(regex, 10);
        for (Map.Entry<String, Thread> e : this.threads.entrySet()) {
            Matcher matcher;
            if (e.getKey() == null || e.getKey().isEmpty() || !(matcher = pattern.matcher(e.getKey())).find()) continue;
            this.threads.get(e.getKey()).interrupt();
            this.threads.remove(e.getKey());
            ++c;
        }
        return c;
    }

    @Override
    public void init() {
        Set<Class<HiveAsyncThread>> threadRunnables = new Reflections("net.dartnode", new Scanner[0]).getSubTypesOf(HiveAsyncThread.class);
        for (Class<HiveAsyncThread> c : threadRunnables) {
            if (HiveAsyncThread.class.isAssignableFrom(c)) {
                AsyncThread at;
                System.out.println("\t\tAsync Thread Interface " + c.getSimpleName());
                if (!c.isAnnotationPresent(AsyncThread.class) || (at = c.getAnnotation(AsyncThread.class)) == null) continue;
                try {
                    HiveAsyncThread t = c.newInstance();
                    System.out.println("\t\t\tStarting Async Thread: " + at.name());
                    this.runDedicatedThread(at.name(), t);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
                continue;
            }
            System.err.println(c.getSimpleName() + " does not except HiveAsyncThread");
        }
    }
}

