/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon.entites.injection;

import com.google.inject.Injector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.ServiceConfigurationError;

public class GuiceServiceLoader<S>
implements Iterable<S> {
    private static final String PREFIX = "META-INF/services/";
    private static Injector globalInjector;
    private final Injector injector;
    private final Class<S> service;
    private final ClassLoader loader;
    private final AccessControlContext acc;
    private LinkedHashMap<String, S> providers = new LinkedHashMap();
    private LazyIterator lookupIterator;

    public void reload() {
        this.providers.clear();
        this.lookupIterator = new LazyIterator(this.service, this.loader);
    }

    private GuiceServiceLoader(Class<S> svc, Injector injector, ClassLoader cl) {
        this.injector = Objects.requireNonNull(injector, "Injector cannot be null.");
        this.service = Objects.requireNonNull(svc, "Service interface cannot be null");
        this.loader = cl == null ? ClassLoader.getSystemClassLoader() : cl;
        this.acc = System.getSecurityManager() != null ? AccessController.getContext() : null;
        this.reload();
    }

    private static void fail(Class<?> service, String msg, Throwable cause) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg, cause);
    }

    private static void fail(Class<?> service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static void fail(Class<?> service, URL u, int line, String msg) throws ServiceConfigurationError {
        GuiceServiceLoader.fail(service, u + ":" + line + ": " + msg);
    }

    private int parseLine(Class<?> service, URL u, BufferedReader r, int lc, List<String> names) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                GuiceServiceLoader.fail(service, u, lc, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                GuiceServiceLoader.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                GuiceServiceLoader.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            if (!this.providers.containsKey(ln) && !names.contains(ln)) {
                names.add(ln);
            }
        }
        return lc + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<String> parse(Class<?> service, URL u) throws ServiceConfigurationError {
        InputStream in = null;
        BufferedReader r = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            in = u.openStream();
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
            int lc = 1;
            while ((lc = this.parseLine(service, u, r, lc, names)) >= 0) {
            }
        }
        catch (IOException x) {
            GuiceServiceLoader.fail(service, "Error reading configuration file", x);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                GuiceServiceLoader.fail(service, "Error closing configuration file", y);
            }
        }
        return names.iterator();
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            Iterator<Map.Entry<String, S>> knownProviders;
            {
                this.knownProviders = GuiceServiceLoader.this.providers.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.knownProviders.hasNext()) {
                    return true;
                }
                return GuiceServiceLoader.this.lookupIterator.hasNext();
            }

            @Override
            public S next() {
                if (this.knownProviders.hasNext()) {
                    return this.knownProviders.next().getValue();
                }
                return GuiceServiceLoader.this.lookupIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <S> GuiceServiceLoader<S> load(Class<S> service, Injector injector, ClassLoader loader) {
        return new GuiceServiceLoader<S>(service, injector, loader);
    }

    public static <S> GuiceServiceLoader<S> load(Class<S> service, Injector injector) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return GuiceServiceLoader.load(service, injector, cl);
    }

    public static <S> GuiceServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        return GuiceServiceLoader.load(service, Objects.requireNonNull(globalInjector, "You must pass an injector or set the global injector!"), loader);
    }

    public static <S> GuiceServiceLoader<S> load(Class<S> service) {
        return GuiceServiceLoader.load(service, Objects.requireNonNull(globalInjector, "You must pass an injector or set the global injector!"));
    }

    public static <S> GuiceServiceLoader<S> loadInstalled(Class<S> service) {
        ClassLoader prev = null;
        for (ClassLoader cl = ClassLoader.getSystemClassLoader(); cl != null; cl = cl.getParent()) {
            prev = cl;
        }
        return GuiceServiceLoader.load(service, globalInjector, prev);
    }

    public static Injector getGlobalInjector() {
        return globalInjector;
    }

    public static void setGlobalInjector(Injector globalInjector) {
        GuiceServiceLoader.globalInjector = globalInjector;
    }

    public String toString() {
        return this.getClass().getCanonicalName() + "[" + this.service.getName() + "]";
    }

    private class LazyIterator
    implements Iterator<S> {
        Class<S> service;
        ClassLoader loader;
        Enumeration<URL> configs = null;
        Iterator<String> pending = null;
        String nextName = null;

        private LazyIterator(Class<S> service, ClassLoader loader) {
            this.service = service;
            this.loader = loader;
        }

        private boolean hasNextService() {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                try {
                    String fullName = GuiceServiceLoader.PREFIX + this.service.getName();
                    this.configs = this.loader == null ? ClassLoader.getSystemResources(fullName) : this.loader.getResources(fullName);
                }
                catch (IOException x) {
                    GuiceServiceLoader.fail(this.service, "Error locating configuration files", x);
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.pending = GuiceServiceLoader.this.parse(this.service, this.configs.nextElement());
            }
            this.nextName = this.pending.next();
            return true;
        }

        private S nextService() {
            if (!this.hasNextService()) {
                throw new NoSuchElementException();
            }
            String cn = this.nextName;
            this.nextName = null;
            Class<?> c = null;
            try {
                c = Class.forName(cn, false, this.loader);
            }
            catch (ClassNotFoundException x) {
                GuiceServiceLoader.fail(this.service, "Provider " + cn + " not found");
            }
            if (!this.service.isAssignableFrom(c)) {
                GuiceServiceLoader.fail(this.service, "Provider " + cn + " not a subtype");
            }
            try {
                Object p = this.service.cast(GuiceServiceLoader.this.injector.getInstance(c));
                GuiceServiceLoader.this.providers.put(cn, p);
                return p;
            }
            catch (Throwable x) {
                GuiceServiceLoader.fail(this.service, "Provider " + cn + " could not be instantiated", x);
                throw new Error();
            }
        }

        @Override
        public boolean hasNext() {
            if (GuiceServiceLoader.this.acc == null) {
                return this.hasNextService();
            }
            return AccessController.doPrivileged(this::hasNextService, GuiceServiceLoader.this.acc);
        }

        @Override
        public S next() {
            if (GuiceServiceLoader.this.acc == null) {
                return this.nextService();
            }
            return AccessController.doPrivileged(this::nextService, GuiceServiceLoader.this.acc);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

