/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon.entites.events;

import java.util.LinkedList;
import net.dartnode.mon.DartNodeCore;
import net.dartnode.mon.entites.events.EventHook;
import net.dartnode.mon.entites.events.EventManager;

public abstract class Event<C> {
    protected boolean isCanceled = false;

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean canceled) {
        this.isCanceled = canceled;
    }

    public void call() {
        EventManager eventService = DartNodeCore.get(EventManager.class);
        if (eventService != null) {
            if (!eventService.getHooks().containsKey(this.getClass())) {
                eventService.getHooks().put(this.getClass(), new LinkedList());
            }
            if (eventService.getHooks().containsKey(this.getClass())) {
                LinkedList<EventHook> hooks = eventService.getHooks().get(this.getClass());
                hooks.sort((o1, o2) -> {
                    if (o1.getPriority().getPriority() > o2.getPriority().getPriority()) {
                        return -1;
                    }
                    if (o1.getPriority().getPriority() < o2.getPriority().getPriority()) {
                        return 1;
                    }
                    return 0;
                });
                for (EventHook hook : hooks) {
                    hook.run(this);
                    if (!this.isCanceled) continue;
                    break;
                }
            } else {
                System.err.println("No Event Hooks for event " + this.getClass());
            }
        } else {
            System.err.println("Failed to call Event, EventService is not started... skipping.");
        }
    }
}

