/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon.entites.command;

import net.dartnode.mon.DartNodeCore;
import net.dartnode.mon.entites.command.HiveCommand;
import net.dartnode.mon.entites.net.HiveCommandMessage;
import net.dartnode.mon.entites.net.HiveReplyMessage;
import net.dartnode.mon.entites.net.MessageHandler;
import net.dartnode.mon.entites.net.NetCommandSource;
import net.dartnode.mon.service.CommandService;

public class CommandHandler {
    private MessageHandler messageHandler;

    public CommandHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void handle(Object obj, NetCommandSource source2) {
        if (HiveCommandMessage.class.isAssignableFrom(obj.getClass())) {
            HiveCommandMessage message = (HiveCommandMessage)obj;
            HiveCommand hc = DartNodeCore.get(CommandService.class).findNetCommand(message.cmd);
            if (hc != null && (hc.allowedSource == source2 || hc.allowedSource == NetCommandSource.ANY)) {
                message.commandSource = source2;
                HiveReplyMessage hr = hc.onCommand(message);
                if (hr != null) {
                    this.messageHandler.routeOut(hr, message.channel);
                }
            } else {
                System.out.println("No command by name: " + message.cmd + " from source " + source2.toString());
            }
        } else if (HiveReplyMessage.class.isAssignableFrom(obj.getClass())) {
            HiveReplyMessage message = (HiveReplyMessage)obj;
            CommandService commandService = DartNodeCore.get(CommandService.class);
            commandService.triggerReplyHooks(message);
        }
    }
}

