/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dartnode.mon.DartNodeCore;
import net.dartnode.mon.VMStatThread;
import net.dartnode.mon.entites.util.cli.CliUtil;
import net.dartnode.mon.service.RedisService;
import net.dartnode.mon.service.ThreadService;

public class VMStatsCollector {
    public static ConcurrentLinkedQueue<Integer> VMs = new ConcurrentLinkedQueue();
    public static ConcurrentLinkedQueue<Integer> processQueue = new ConcurrentLinkedQueue();
    public static ConcurrentLinkedQueue<Thread> threads = new ConcurrentLinkedQueue();

    public static void init() {
        try {
            VMStatsCollector.buildPool();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int totalVMs = VMs.size();
        System.out.println("Found " + totalVMs + " VMs");
        int runners = (int)Math.ceil(totalVMs / 10);
        if (runners < 10) {
            runners = 10;
        }
        for (int i = 0; i < runners; ++i) {
            Thread t = DartNodeCore.get(ThreadService.class).runDedicatedThread("vm-" + i, new VMStatThread());
            threads.add(t);
        }
    }

    public static void buildPool() throws IOException {
        JsonArray vms = JsonParser.parseString(CliUtil.exec("pvesh get /nodes/localhost/qemu --output-format json")).getAsJsonArray();
        LinkedList<Integer> currentVMs = new LinkedList<Integer>();
        for (JsonElement vmMeta : vms) {
            JsonObject o = vmMeta.getAsJsonObject();
            if (o.has("template") || !o.has("pid")) continue;
            Integer vmId = o.get("vmid").getAsInt();
            currentVMs.add(vmId);
            if (!VMs.contains(vmId)) {
                VMs.add(vmId);
            }
            if (processQueue.contains(vmId)) continue;
            processQueue.add(vmId);
        }
        for (Integer vmId : VMs) {
            if (currentVMs.contains(vmId)) continue;
            VMs.remove(vmId);
        }
    }

    public static void processVM(Integer vmId) throws IOException {
        String lastString = (String)DartNodeCore.get(RedisService.class).getRedisConnection().sync().get("last_" + vmId);
        JsonObject last = null;
        if (lastString != null) {
            last = JsonParser.parseString((String)DartNodeCore.get(RedisService.class).getRedisConnection().sync().get("last_" + vmId)).getAsJsonObject();
            last.remove("snapshot");
        }
        JsonObject conf = JsonParser.parseString(CliUtil.exec("pvesh get /nodes/localhost/qemu/" + vmId + "/config --output-format json")).getAsJsonObject();
        Map<String, String> storageMeta = VMStatsCollector.getStorageOptionsFromString(conf.get("scsi0").getAsString());
        JsonObject storage = JsonParser.parseString(CliUtil.exec("pvesh get /nodes/localhost/storage/" + storageMeta.get("storage") + "/content/" + storageMeta.get("volume") + " --output-format json")).getAsJsonObject();
        JsonObject hostName = VMStatsCollector.getDataObj("/nodes/localhost/qemu/" + vmId + "/agent/get-host-name");
        JsonObject osInfo = VMStatsCollector.getDataObj("/nodes/localhost/qemu/" + vmId + "/agent/get-osinfo");
        JsonObject networkInfo = VMStatsCollector.getDataObj("/nodes/localhost/qemu/" + vmId + "/agent/network-get-interfaces");
        JsonObject status = VMStatsCollector.getDataObj("/nodes/localhost/qemu/" + vmId + "/status/current");
        JsonObject _d = new JsonObject();
        _d.add("stats", status);
        _d.add("network", networkInfo);
        _d.add("host", hostName);
        _d.add("os", osInfo);
        _d.add("disk", storage);
        _d.addProperty("ts", System.currentTimeMillis() / 1000L);
        _d.add("snapshot", last);
        DartNodeCore.get(RedisService.class).getRedisConnection().sync().set("vm:stats:last:" + vmId, _d.toString());
        DartNodeCore.get(RedisService.class).getRedisConnection().sync().set("vm:stats:current:" + vmId, _d.toString());
    }

    public static JsonObject getDataObj(String path) {
        try {
            String d = CliUtil.exec("pvesh get " + path + " --output-format json");
            JsonObject o = JsonParser.parseString(d).getAsJsonObject();
            return o;
        }
        catch (Exception e) {
            return new JsonObject();
        }
    }

    public static Map<String, String> getStorageOptionsFromString(String storage) {
        String regex = "((.*?)\\:(.*?)),(.*)";
        Pattern pattern = Pattern.compile(regex, 10);
        Matcher matcher = pattern.matcher(storage);
        if (!matcher.matches()) {
            return null;
        }
        String vmVolumeId = matcher.group(1);
        String vmStorage = matcher.group(2);
        String vmePath = matcher.group(3);
        String vmOptions = matcher.group(4);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("volume", vmVolumeId);
        result.put("storage", vmStorage);
        result.put("path", vmePath);
        result.put("options", vmOptions);
        return result;
    }
}

