/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.UUID;
import net.dartnode.mon.entites.command.HiveConsoleCommand;
import net.dartnode.mon.entites.config.HiveConfigFile;
import net.dartnode.mon.entites.events.EventManager;
import net.dartnode.mon.entites.injection.AppInjector;
import net.dartnode.mon.entites.injection.GuiceServiceLoader;
import net.dartnode.mon.entites.injection.InjectionModule;
import net.dartnode.mon.entites.injection.InjectionRoot;
import net.dartnode.mon.entites.service.HiveService;
import net.dartnode.mon.service.CommandService;
import org.apache.commons.io.IOUtils;

public class DartNodeCore
implements InjectionRoot {
    public static DartNodeCore instance;
    public static boolean isRunning;
    private final HiveConfigFile configFile;
    public static boolean inDevMode;
    @Inject
    Injector injector;

    public DartNodeCore(String configPath) {
        instance = this;
        AppInjector.registerInjectionRoot(this);
        AppInjector.registerRootModule(new InjectionModule(this));
        AppInjector.boot();
        System.out.println("ROOT: " + System.getProperty("user.dir"));
        if (configPath != null) {
            if (!Files.exists(Paths.get(configPath, new String[0]), new LinkOption[0])) {
                System.out.println("Hive Config not found... generating...");
                ClassLoader classloader = Thread.currentThread().getContextClassLoader();
                try (InputStream in = classloader.getResourceAsStream("config.json");
                     BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                    String defaultConfig = IOUtils.toString(reader);
                    Files.write(Paths.get(configPath, new String[0]), defaultConfig.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Loading Config into System...");
            this.configFile = new HiveConfigFile(new File(configPath));
            try {
                this.configFile.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!this.configFile.getConfig().has("name")) {
                System.out.println("Config does not have name set... generating node id...");
                this.configFile.getConfig().addProperty("name", UUID.randomUUID().toString());
                try {
                    this.configFile.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.configFile.getConfig().has("dev")) {
                inDevMode = this.configFile.getConfig().get("dev").getAsBoolean();
            }
            if (inDevMode) {
                System.out.println("!!!! IN DEV MODE");
            }
        } else {
            this.configFile = null;
        }
        GuiceServiceLoader.getGlobalInjector().injectMembers(EventManager.class);
        GuiceServiceLoader.load(HiveService.class).forEach(hiveService -> {
            System.out.println("--- Starting " + hiveService.getClass().getSimpleName());
            hiveService.init();
        });
        System.out.println("System Ready.");
    }

    public static void awaitConsoleInput() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Server Running and awaiting command...");
        while (isRunning) {
            try {
                String name = reader.readLine();
                if (name != null) {
                    HiveConsoleCommand ci;
                    System.out.println("CONSOLE CMD: " + name);
                    String[] parts = name.split(" ");
                    String cmdName = parts[0];
                    String[] args2 = new String[]{};
                    if (parts.length > 1) {
                        args2 = Arrays.copyOfRange(parts, 1, parts.length);
                    }
                    if ((ci = DartNodeCore.get(CommandService.class).findConsoleCommand(cmdName)) != null) {
                        if (!ci.onCommand(cmdName, args2)) {
                            System.out.println("Error Processing Command");
                        }
                    } else {
                        System.err.println("CMD Not Found");
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> T get(Class<? extends T> type) {
        return instance.getInjector().getInstance(type);
    }

    public Injector getInjector() {
        return this.injector;
    }

    public HiveConfigFile getConfigFile() {
        return this.configFile;
    }

    static {
        isRunning = true;
        inDevMode = false;
    }
}

