/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.apache;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kong.unirest.Config;
import kong.unirest.UnirestConfigException;
import kong.unirest.apache.ApacheNoRedirectStrategy;
import kong.unirest.apache.AsyncIdleConnectionMonitorThread;
import kong.unirest.apache.BaseApacheClient;
import kong.unirest.apache.RequestOptions;
import kong.unirest.apache.Util;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContextBuilder;

class ApacheAsyncConfig {
    final HttpAsyncClient client;
    final Config config;
    private AsyncIdleConnectionMonitorThread syncMonitor;
    private PoolingNHttpClientConnectionManager manager;
    private boolean hookset;

    public ApacheAsyncConfig(Config config) {
        this.config = config;
        try {
            this.manager = this.createConnectionManager();
            this.manager.setMaxTotal(config.getMaxConnections());
            this.manager.setDefaultMaxPerRoute(config.getMaxPerRoutes());
            HttpAsyncClientBuilder ab = HttpAsyncClientBuilder.create().setDefaultRequestConfig(RequestOptions.toRequestConfig(config)).setConnectionManager(this.manager).setDefaultCredentialsProvider(BaseApacheClient.toApacheCreds(config.getProxy())).useSystemProperties();
            this.setOptions(ab);
            CloseableHttpAsyncClient build = ab.build();
            build.start();
            this.syncMonitor = new AsyncIdleConnectionMonitorThread(this.manager);
            this.syncMonitor.tryStart();
            this.client = build;
            if (config.shouldAddShutdownHook()) {
                this.registerShutdownHook();
            }
        }
        catch (Exception e) {
            throw new UnirestConfigException(e);
        }
    }

    private void setOptions(HttpAsyncClientBuilder ab) {
        if (!this.config.isVerifySsl()) {
            this.disableSsl(ab);
        }
        if (this.config.useSystemProperties()) {
            ab.useSystemProperties();
        }
        if (!this.config.getFollowRedirects()) {
            ab.setRedirectStrategy(new ApacheNoRedirectStrategy());
        }
        if (!this.config.getEnabledCookieManagement()) {
            ab.disableCookieManagement();
        }
        this.config.getInterceptor().forEach(ab::addInterceptorFirst);
    }

    private PoolingNHttpClientConnectionManager createConnectionManager() throws Exception {
        return new PoolingNHttpClientConnectionManager(new DefaultConnectingIOReactor(), null, this.getRegistry(), null, null, this.config.getTTL(), TimeUnit.MILLISECONDS);
    }

    private Registry<SchemeIOSessionStrategy> getRegistry() throws Exception {
        if (this.config.isVerifySsl()) {
            return RegistryBuilder.create().register("http", NoopIOSessionStrategy.INSTANCE).register("https", (NoopIOSessionStrategy)((Object)SSLIOSessionStrategy.getDefaultStrategy())).build();
        }
        return RegistryBuilder.create().register("http", NoopIOSessionStrategy.INSTANCE).register("https", (NoopIOSessionStrategy)((Object)new SSLIOSessionStrategy(new SSLContextBuilder().loadTrustMaterial(null, (x509Certificates, s2) -> true).build(), NoopHostnameVerifier.INSTANCE))).build();
    }

    private void disableSsl(HttpAsyncClientBuilder ab) {
        try {
            ab.setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE);
            ab.setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, (arg0, arg1) -> true).build());
        }
        catch (Exception e) {
            throw new UnirestConfigException(e);
        }
    }

    public ApacheAsyncConfig(HttpAsyncClient client, Config config) {
        this.client = client;
        this.config = config;
    }

    @Deprecated
    public ApacheAsyncConfig(HttpAsyncClient client, Config config, PoolingNHttpClientConnectionManager manager, AsyncIdleConnectionMonitorThread monitor2) {
        Objects.requireNonNull(client, "Client may not be null");
        this.config = config;
        this.client = client;
        this.syncMonitor = monitor2;
        this.manager = manager;
    }

    public void registerShutdownHook() {
        if (!this.hookset) {
            this.hookset = true;
            Runtime.getRuntime().addShutdownHook(new Thread(this::close, "Unirest Apache Async Client Shutdown Hook"));
        }
    }

    public boolean isRunning() {
        return Util.tryCast(this.client, CloseableHttpAsyncClient.class).map(CloseableHttpAsyncClient::isRunning).orElse(true);
    }

    public HttpAsyncClient getClient() {
        return this.client;
    }

    public Stream<Exception> close() {
        return Util.collectExceptions(Util.tryCast(this.client, CloseableHttpAsyncClient.class).filter(c -> c.isRunning()).map(c -> Util.tryDo(c, d -> d.close())).filter(c -> c.isPresent()).map(c -> (Exception)c.get()), Util.tryDo(this.manager, m3 -> m3.shutdown()), Util.tryDo(this.syncMonitor, m3 -> m3.interrupt()));
    }
}

