/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.sentinel;

import io.lettuce.core.AbstractRedisReactiveCommands;
import io.lettuce.core.KillArgs;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.lettuce.core.sentinel.SentinelCommandBuilder;
import io.lettuce.core.sentinel.api.StatefulRedisSentinelConnection;
import io.lettuce.core.sentinel.api.reactive.RedisSentinelReactiveCommands;
import java.net.SocketAddress;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedisSentinelReactiveCommandsImpl<K, V>
extends AbstractRedisReactiveCommands<K, V>
implements RedisSentinelReactiveCommands<K, V> {
    private final SentinelCommandBuilder<K, V> commandBuilder;

    public RedisSentinelReactiveCommandsImpl(StatefulConnection<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
        this.commandBuilder = new SentinelCommandBuilder<K, V>(codec);
    }

    @Override
    public Mono<SocketAddress> getMasterAddrByName(K key) {
        return this.createMono(() -> this.commandBuilder.getMasterAddrByKey(key));
    }

    @Override
    public Flux<Map<K, V>> masters() {
        return this.createDissolvingFlux(this.commandBuilder::masters);
    }

    @Override
    public Mono<Map<K, V>> master(K key) {
        return this.createMono(() -> this.commandBuilder.master(key));
    }

    @Override
    public Flux<Map<K, V>> slaves(K key) {
        return this.createDissolvingFlux(() -> this.commandBuilder.slaves(key));
    }

    @Override
    public Mono<Long> reset(K key) {
        return this.createMono(() -> this.commandBuilder.reset(key));
    }

    @Override
    public Mono<String> failover(K key) {
        return this.createMono(() -> this.commandBuilder.failover(key));
    }

    @Override
    public Mono<String> monitor(K key, String ip, int port, int quorum) {
        return this.createMono(() -> this.commandBuilder.monitor(key, ip, port, quorum));
    }

    @Override
    public Mono<String> set(K key, String option, V value) {
        return this.createMono(() -> this.commandBuilder.set(key, option, value));
    }

    @Override
    public Mono<String> remove(K key) {
        return this.createMono(() -> this.commandBuilder.remove(key));
    }

    @Override
    public Mono<String> ping() {
        return this.createMono(this.commandBuilder::ping);
    }

    @Override
    public Mono<K> clientGetname() {
        return this.createMono(this.commandBuilder::clientGetname);
    }

    @Override
    public Mono<String> clientSetname(K name) {
        return this.createMono(() -> this.commandBuilder.clientSetname(name));
    }

    @Override
    public Mono<String> clientKill(String addr) {
        return this.createMono(() -> this.commandBuilder.clientKill(addr));
    }

    @Override
    public Mono<Long> clientKill(KillArgs killArgs) {
        return this.createMono(() -> this.commandBuilder.clientKill(killArgs));
    }

    @Override
    public Mono<String> clientPause(long timeout2) {
        return this.createMono(() -> this.commandBuilder.clientPause(timeout2));
    }

    @Override
    public Mono<String> clientList() {
        return this.createMono(this.commandBuilder::clientList);
    }

    @Override
    public Mono<String> info() {
        return this.createMono(this.commandBuilder::info);
    }

    @Override
    public Mono<String> info(String section) {
        return this.createMono(() -> this.commandBuilder.info(section));
    }

    @Override
    public <T> Flux<T> dispatch(ProtocolKeyword type, CommandOutput<K, V, ?> output) {
        LettuceAssert.notNull((Object)type, "Command type must not be null");
        LettuceAssert.notNull(output, "CommandOutput type must not be null");
        return this.createFlux(() -> new Command(type, output));
    }

    @Override
    public <T> Flux<T> dispatch(ProtocolKeyword type, CommandOutput<K, V, ?> output, CommandArgs<K, V> args2) {
        LettuceAssert.notNull((Object)type, "Command type must not be null");
        LettuceAssert.notNull(output, "CommandOutput type must not be null");
        LettuceAssert.notNull(args2, "CommandArgs type must not be null");
        return this.createFlux(() -> new Command(type, output, args2));
    }

    @Override
    public void close() {
        this.getStatefulConnection().close();
    }

    @Override
    public boolean isOpen() {
        return this.getStatefulConnection().isOpen();
    }

    @Override
    public StatefulRedisSentinelConnection<K, V> getStatefulConnection() {
        return (StatefulRedisSentinelConnection)super.getConnection();
    }
}

