/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.resource.EventLoopResources;
import io.lettuce.core.resource.EventLoopResourcesWrapper;
import io.lettuce.core.resource.UnavailableResources;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;

public class KqueueProvider {
    private static final InternalLogger logger;
    private static final String KQUEUE_ENABLED_KEY = "io.lettuce.core.kqueue";
    private static final boolean KQUEUE_ENABLED;
    private static final boolean KQUEUE_AVAILABLE;
    private static final EventLoopResources KQUEUE_RESOURCES;

    public static boolean isAvailable() {
        return KQUEUE_AVAILABLE && KQUEUE_ENABLED;
    }

    static void checkForKqueueLibrary() {
        LettuceAssert.assertState(KQUEUE_ENABLED, String.format("kqueue use is disabled via System properties (%s)", KQUEUE_ENABLED_KEY));
        LettuceAssert.assertState(KqueueProvider.isAvailable(), "netty-transport-native-kqueue is not available. Make sure netty-transport-native-kqueue library on the class path and supported by your operating system.");
    }

    public static EventLoopResources getResources() {
        return KQUEUE_RESOURCES;
    }

    static {
        boolean availability;
        logger = InternalLoggerFactory.getInstance(KqueueProvider.class);
        KQUEUE_ENABLED = Boolean.parseBoolean(SystemPropertyUtil.get(KQUEUE_ENABLED_KEY, "true"));
        try {
            Class.forName("io.netty.channel.kqueue.KQueue");
            availability = KQueue.isAvailable();
        }
        catch (ClassNotFoundException e) {
            availability = false;
        }
        KQUEUE_AVAILABLE = availability;
        if (KQUEUE_AVAILABLE) {
            logger.debug("Starting with kqueue library");
            KQUEUE_RESOURCES = new EventLoopResourcesWrapper(KqueueResources.INSTANCE, KqueueProvider::checkForKqueueLibrary);
        } else {
            logger.debug("Starting without optional kqueue library");
            KQUEUE_RESOURCES = new EventLoopResourcesWrapper(UnavailableResources.INSTANCE, KqueueProvider::checkForKqueueLibrary);
        }
    }

    static enum KqueueResources implements EventLoopResources
    {
        INSTANCE;


        @Override
        public boolean matches(Class<? extends EventExecutorGroup> type) {
            LettuceAssert.notNull(type, "EventLoopGroup type must not be null");
            return type.equals(this.eventLoopGroupClass());
        }

        @Override
        public Class<? extends EventLoopGroup> eventLoopGroupClass() {
            KqueueProvider.checkForKqueueLibrary();
            return KQueueEventLoopGroup.class;
        }

        @Override
        public EventLoopGroup newEventLoopGroup(int nThreads, ThreadFactory threadFactory2) {
            KqueueProvider.checkForKqueueLibrary();
            return new KQueueEventLoopGroup(nThreads, threadFactory2);
        }

        @Override
        public Class<? extends Channel> socketChannelClass() {
            KqueueProvider.checkForKqueueLibrary();
            return KQueueSocketChannel.class;
        }

        @Override
        public Class<? extends DatagramChannel> datagramChannelClass() {
            KqueueProvider.checkForKqueueLibrary();
            return KQueueDatagramChannel.class;
        }

        @Override
        public Class<? extends Channel> domainSocketChannelClass() {
            KqueueProvider.checkForKqueueLibrary();
            return KQueueDomainSocketChannel.class;
        }

        @Override
        public SocketAddress newSocketAddress(String socketPath) {
            KqueueProvider.checkForKqueueLibrary();
            return new DomainSocketAddress(socketPath);
        }
    }

    static enum UnavailableKqueueResources implements EventLoopResources
    {
        INSTANCE;


        @Override
        public boolean matches(Class<? extends EventExecutorGroup> type) {
            KqueueProvider.checkForKqueueLibrary();
            return false;
        }

        @Override
        public Class<? extends EventLoopGroup> eventLoopGroupClass() {
            KqueueProvider.checkForKqueueLibrary();
            return null;
        }

        @Override
        public EventLoopGroup newEventLoopGroup(int nThreads, ThreadFactory threadFactory2) {
            KqueueProvider.checkForKqueueLibrary();
            return null;
        }

        @Override
        public Class<? extends Channel> socketChannelClass() {
            KqueueProvider.checkForKqueueLibrary();
            return null;
        }

        @Override
        public Class<? extends Channel> domainSocketChannelClass() {
            KqueueProvider.checkForKqueueLibrary();
            return null;
        }

        @Override
        public SocketAddress newSocketAddress(String socketPath) {
            KqueueProvider.checkForKqueueLibrary();
            return null;
        }

        @Override
        public Class<? extends DatagramChannel> datagramChannelClass() {
            KqueueProvider.checkForKqueueLibrary();
            return null;
        }
    }
}

