/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.protocol;

import io.lettuce.core.RedisException;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.BooleanOutput;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.output.NestedMultiOutput;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.output.ValueOutput;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandType;

public class BaseRedisCommandBuilder<K, V> {
    protected final RedisCodec<K, V> codec;

    public BaseRedisCommandBuilder(RedisCodec<K, V> codec) {
        this.codec = codec;
    }

    protected <T> Command<K, V, T> createCommand(CommandType type, CommandOutput<K, V, T> output) {
        return this.createCommand(type, output, (CommandArgs)null);
    }

    protected <T> Command<K, V, T> createCommand(CommandType type, CommandOutput<K, V, T> output, K key) {
        CommandArgs<K, V> args2 = new CommandArgs<K, V>(this.codec).addKey(key);
        return this.createCommand(type, output, args2);
    }

    protected <T> Command<K, V, T> createCommand(CommandType type, CommandOutput<K, V, T> output, K key, V value) {
        CommandArgs<K, V> args2 = new CommandArgs<K, V>(this.codec).addKey(key).addValue(value);
        return this.createCommand(type, output, args2);
    }

    protected <T> Command<K, V, T> createCommand(CommandType type, CommandOutput<K, V, T> output, K key, V[] values2) {
        CommandArgs<K, V> args2 = new CommandArgs<K, V>(this.codec).addKey(key).addValues(values2);
        return this.createCommand(type, output, args2);
    }

    protected <T> Command<K, V, T> createCommand(CommandType type, CommandOutput<K, V, T> output, CommandArgs<K, V> args2) {
        return new Command<K, V, T>(type, output, args2);
    }

    protected <T> CommandOutput<K, V, T> newScriptOutput(RedisCodec<K, V> codec, ScriptOutputType type) {
        switch (type) {
            case BOOLEAN: {
                return new BooleanOutput<K, V>(codec);
            }
            case INTEGER: {
                return new IntegerOutput<K, V>(codec);
            }
            case STATUS: {
                return new StatusOutput<K, V>(codec);
            }
            case MULTI: {
                return new NestedMultiOutput<K, V>(codec);
            }
            case VALUE: {
                return new ValueOutput<K, V>(codec);
            }
        }
        throw new RedisException("Unsupported script output type");
    }
}

