/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.internal;

import io.lettuce.core.RedisFuture;
import io.lettuce.core.internal.ExceptionFactory;
import io.lettuce.core.internal.Exceptions;
import io.lettuce.core.internal.LettuceAssert;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class Futures {
    private Futures() {
    }

    public static CompletableFuture<Void> allOf(Collection<? extends CompletionStage<?>> stages) {
        LettuceAssert.notNull(stages, "Futures must not be null");
        CompletableFuture[] futures = new CompletableFuture[stages.size()];
        int index = 0;
        for (CompletionStage<?> stage : stages) {
            futures[index++] = stage.toCompletableFuture();
        }
        return CompletableFuture.allOf(futures);
    }

    public static <T> CompletableFuture<T> failed(Throwable throwable) {
        LettuceAssert.notNull((Object)throwable, "Throwable must not be null");
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(throwable);
        return future;
    }

    public static <V> CompletionStage<V> toCompletionStage(io.netty.util.concurrent.Future<V> future) {
        LettuceAssert.notNull(future, "Future must not be null");
        CompletableFuture promise = new CompletableFuture();
        if (future.isDone() || future.isCancelled()) {
            if (future.isSuccess()) {
                promise.complete(null);
            } else {
                promise.completeExceptionally(future.cause());
            }
            return promise;
        }
        future.addListener(f -> {
            if (f.isSuccess()) {
                promise.complete(null);
            } else {
                promise.completeExceptionally(f.cause());
            }
        });
        return promise;
    }

    public static <V> void adapt(io.netty.util.concurrent.Future<V> source2, CompletableFuture<V> target) {
        source2.addListener(f -> {
            if (f.isSuccess()) {
                target.complete(null);
            } else {
                target.completeExceptionally(f.cause());
            }
        });
        if (source2.isSuccess()) {
            target.complete(null);
        } else if (source2.isCancelled()) {
            target.cancel(false);
        } else if (source2.isDone() && !source2.isSuccess()) {
            target.completeExceptionally(source2.cause());
        }
    }

    public static boolean await(Duration timeout2, Future<?> future) {
        return Futures.await(timeout2.toNanos(), TimeUnit.NANOSECONDS, future);
    }

    public static boolean await(long timeout2, TimeUnit unit, Future<?> future) {
        try {
            long nanos = unit.toNanos(timeout2);
            if (nanos < 0L) {
                return false;
            }
            if (nanos == 0L) {
                future.get();
            } else {
                future.get(nanos, TimeUnit.NANOSECONDS);
            }
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
        catch (Exception e) {
            throw Exceptions.fromSynchronization(e);
        }
    }

    public static boolean awaitAll(Duration timeout2, Future<?> ... futures) {
        return Futures.awaitAll(timeout2.toNanos(), TimeUnit.NANOSECONDS, futures);
    }

    public static boolean awaitAll(long timeout2, TimeUnit unit, Future<?> ... futures) {
        try {
            long nanos = unit.toNanos(timeout2);
            long time = System.nanoTime();
            for (Future<?> f : futures) {
                if (timeout2 <= 0L) {
                    f.get();
                    continue;
                }
                if (nanos < 0L) {
                    return false;
                }
                f.get(nanos, TimeUnit.NANOSECONDS);
                long now = System.nanoTime();
                nanos -= now - time;
                time = now;
            }
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
        catch (Exception e) {
            throw Exceptions.fromSynchronization(e);
        }
    }

    public static <T> T awaitOrCancel(RedisFuture<T> cmd, long timeout2, TimeUnit unit) {
        try {
            if (timeout2 > 0L && !cmd.await(timeout2, unit)) {
                cmd.cancel(true);
                throw ExceptionFactory.createTimeoutException(Duration.ofNanos(unit.toNanos(timeout2)));
            }
            return (T)cmd.get();
        }
        catch (Exception e) {
            throw Exceptions.bubble(e);
        }
    }
}

