/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic.domain;

import io.lettuce.core.internal.LettuceAssert;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class Timeout {
    private final Duration timeout;

    private Timeout(Duration timeout2) {
        LettuceAssert.notNull((Object)timeout2, "Timeout must not be null");
        LettuceAssert.isTrue(!timeout2.isNegative(), "Timeout must be greater or equal to zero");
        this.timeout = timeout2;
    }

    public static Timeout create(Duration timeout2) {
        return new Timeout(timeout2);
    }

    public static Timeout create(long timeout2, TimeUnit timeUnit) {
        LettuceAssert.notNull((Object)timeUnit, "TimeUnit must not be null");
        return new Timeout(Duration.ofNanos(timeUnit.toNanos(timeout2)));
    }

    public Duration getTimeout() {
        return this.timeout;
    }
}

