/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;

public class XTrimArgs
implements CompositeArgument {
    private Long maxlen;
    private boolean approximateTrimming;
    private boolean exactTrimming;
    private String minId;
    private Long limit;

    public XTrimArgs maxlen(long maxlen) {
        LettuceAssert.isTrue(maxlen > 0L, "Maxlen must be greater 0");
        this.maxlen = maxlen;
        return this;
    }

    public XTrimArgs minId(String minid) {
        LettuceAssert.notNull((Object)minid, "minId must not be null");
        this.minId = minid;
        return this;
    }

    public XTrimArgs limit(long limit) {
        LettuceAssert.isTrue(limit > 0L, "Limit must be greater 0");
        this.limit = limit;
        return this;
    }

    public XTrimArgs approximateTrimming() {
        return this.approximateTrimming(true);
    }

    public XTrimArgs approximateTrimming(boolean approximateTrimming) {
        this.approximateTrimming = approximateTrimming;
        return this;
    }

    public XTrimArgs exactTrimming() {
        return this.exactTrimming(true);
    }

    public XTrimArgs exactTrimming(boolean exactTrimming) {
        this.exactTrimming = exactTrimming;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args2) {
        if (this.maxlen != null) {
            args2.add(CommandKeyword.MAXLEN);
            if (this.approximateTrimming) {
                args2.add("~");
            } else if (this.exactTrimming) {
                args2.add("=");
            }
            args2.add(this.maxlen);
        } else if (this.minId != null) {
            args2.add(CommandKeyword.MINID);
            if (this.approximateTrimming) {
                args2.add("~");
            } else if (this.exactTrimming) {
                args2.add("=");
            }
            args2.add(this.minId);
        }
        if (this.limit != null && this.approximateTrimming) {
            args2.add(CommandKeyword.LIMIT).add(this.limit);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static XTrimArgs maxlen(long count) {
            return new XTrimArgs().maxlen(count);
        }

        public static XTrimArgs minId(String minid) {
            return new XTrimArgs().minId(minid);
        }
    }
}

