/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;

public class SetArgs
implements CompositeArgument {
    private Long ex;
    private Long exAt;
    private Long px;
    private Long pxAt;
    private boolean nx = false;
    private boolean xx = false;
    private boolean keepttl = false;

    public SetArgs ex(long timeout2) {
        this.ex = timeout2;
        return this;
    }

    public SetArgs ex(Duration timeout2) {
        LettuceAssert.notNull((Object)timeout2, "Timeout must not be null");
        this.ex = timeout2.toMillis() / 1000L;
        return this;
    }

    public SetArgs exAt(long timestamp) {
        this.exAt = timestamp;
        return this;
    }

    public SetArgs exAt(Date timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.exAt(timestamp.getTime() / 1000L);
    }

    public SetArgs exAt(Instant timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.exAt(timestamp.toEpochMilli() / 1000L);
    }

    public SetArgs px(long timeout2) {
        this.px = timeout2;
        return this;
    }

    public SetArgs px(Duration timeout2) {
        LettuceAssert.notNull((Object)timeout2, "Timeout must not be null");
        this.px = timeout2.toMillis();
        return this;
    }

    public SetArgs pxAt(long timestamp) {
        this.pxAt = timestamp;
        return this;
    }

    public SetArgs pxAt(Date timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.pxAt(timestamp.getTime());
    }

    public SetArgs pxAt(Instant timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.pxAt(timestamp.toEpochMilli());
    }

    public SetArgs nx() {
        this.nx = true;
        return this;
    }

    public SetArgs keepttl() {
        this.keepttl = true;
        return this;
    }

    public SetArgs xx() {
        this.xx = true;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args2) {
        if (this.ex != null) {
            args2.add("EX").add(this.ex);
        }
        if (this.exAt != null) {
            args2.add("EXAT").add(this.exAt);
        }
        if (this.px != null) {
            args2.add("PX").add(this.px);
        }
        if (this.pxAt != null) {
            args2.add("PXAT").add(this.pxAt);
        }
        if (this.nx) {
            args2.add(CommandKeyword.NX);
        }
        if (this.xx) {
            args2.add(CommandKeyword.XX);
        }
        if (this.keepttl) {
            args2.add("KEEPTTL");
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static SetArgs ex(long timeout2) {
            return new SetArgs().ex(timeout2);
        }

        public static SetArgs ex(Duration timeout2) {
            return new SetArgs().ex(timeout2);
        }

        public static SetArgs exAt(long timestamp) {
            return new SetArgs().exAt(timestamp);
        }

        public static SetArgs exAt(Date timestamp) {
            return new SetArgs().exAt(timestamp);
        }

        public static SetArgs exAt(Instant timestamp) {
            return new SetArgs().exAt(timestamp);
        }

        public static SetArgs px(long timeout2) {
            return new SetArgs().px(timeout2);
        }

        public static SetArgs px(Duration timeout2) {
            return new SetArgs().px(timeout2);
        }

        public static SetArgs pxAt(long timestamp) {
            return new SetArgs().pxAt(timestamp);
        }

        public static SetArgs pxAt(Date timestamp) {
            return new SetArgs().pxAt(timestamp);
        }

        public static SetArgs pxAt(Instant timestamp) {
            return new SetArgs().pxAt(timestamp);
        }

        public static SetArgs nx() {
            return new SetArgs().nx();
        }

        public static SetArgs xx() {
            return new SetArgs().xx();
        }

        public static SetArgs keepttl() {
            return new SetArgs().keepttl();
        }
    }
}

