/*
 * Decompiled with CFR 0.152.
 */
package io.airbrake.javabrake;

import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.TDigest;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

class TdigestStat {
    int count = 0;
    double sum = 0.0;
    double sumsq = 0.0;
    transient TDigest td = TDigest.createAvlTreeDigest(10.0);
    String tdigest;
    transient int SMALL_ENCODING = 2;
    transient List<byte[]> list = new ArrayList<byte[]>();

    TdigestStat() {
    }

    public void add(long ms) {
        ++this.count;
        this.sum += (double)ms;
        this.sumsq += (double)(ms * ms);
        this.td.add(ms);
        this.tdigest = this.getData();
    }

    public String getData() {
        ByteBuffer buf = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
        buf.putInt(this.SMALL_ENCODING);
        this.list.add(buf.array());
        buf = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        buf.putDouble(10.0);
        this.list.add(buf.array());
        buf = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
        buf.putInt((int)this.td.size());
        this.list.add(buf.array());
        double x = 0.0;
        for (Centroid centroid : this.td.centroids()) {
            buf = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
            double delta = centroid.mean() - x;
            x = centroid.mean();
            buf.putFloat((float)delta);
            this.list.add(buf.array());
        }
        for (Centroid centroid : this.td.centroids()) {
            int n;
            buf = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
            int k = 0;
            for (n = centroid.count(); n < 0 || n > 127; n >>>= 7) {
                byte b = (byte)(0x80 | 0x7F & n);
                buf.put(b);
                if (++k < 6) continue;
                throw new IllegalStateException("Size is implausibly large");
            }
            buf.put((byte)n);
            this.list.add(buf.array());
        }
        int size = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            size += this.list.get(i).length;
        }
        byte[] b = new byte[size];
        int k = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            for (int j = 0; j < this.list.get(i).length; ++j) {
                b[k] = this.list.get(i)[j];
                ++k;
            }
        }
        return Base64.getEncoder().encodeToString(b);
    }

    public void encodeVarint(List<byte[]> b, int num) {
        int c;
        while (true) {
            c = num & 0x7F;
            if ((num >>= 7) <= 0) break;
            b.add(new byte[]{(byte)(c | 0x80)});
        }
        b.add(new byte[]{(byte)c});
    }

    public byte[] serialize(TDigest tDigest) {
        byte[] bytes = new byte[tDigest.byteSize()];
        tDigest.asSmallBytes(ByteBuffer.wrap(bytes));
        return bytes;
    }
}

