/*
 * Decompiled with CFR 0.152.
 */
package io.airbrake.javabrake;

import io.airbrake.javabrake.ApmResponse;
import io.airbrake.javabrake.Constant;
import io.airbrake.javabrake.Metrics;
import io.airbrake.javabrake.Notifier;
import io.airbrake.javabrake.OkAsyncSender;
import io.airbrake.javabrake.OkSender;
import io.airbrake.javabrake.Routes;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;

class RouteTimerTask
extends TimerTask {
    static Timer rTimer = new Timer(true);
    static boolean hasStarted = false;

    RouteTimerTask() {
    }

    public static void start() {
        if (!hasStarted) {
            hasStarted = true;
            rTimer.schedule((TimerTask)new RouteTimerTask(), 0L, (long)(Metrics.FLUSH_PERIOD * 1000));
        }
    }

    @Override
    public void run() {
        hasStarted = true;
        if (Notifier.routeList.size() > 0) {
            Routes routes = new Routes(Notifier.config.environment, Notifier.routeList);
            Notifier.routeList = new ArrayList<Object>();
            CompletableFuture<ApmResponse> future = new OkAsyncSender(Notifier.config).send(OkSender.gson.toJson(routes), Constant.apmRoute);
            future.whenComplete((value, exception) -> {
                if (exception != null) {
                    Routes.status = exception.getMessage();
                } else if (value != null) {
                    Routes.status = value.message;
                }
            });
        }
    }

    public static void stop() {
        rTimer.cancel();
    }
}

