/*
 * Decompiled with CFR 0.152.
 */
package io.airbrake.javabrake;

import io.airbrake.javabrake.ApmResponse;
import io.airbrake.javabrake.Constant;
import io.airbrake.javabrake.Metrics;
import io.airbrake.javabrake.Notifier;
import io.airbrake.javabrake.OkAsyncSender;
import io.airbrake.javabrake.OkSender;
import io.airbrake.javabrake.Queues;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;

class QueueTimerTask
extends TimerTask {
    static Timer rTimer = new Timer(true);
    private static boolean hasStarted = false;

    QueueTimerTask() {
    }

    public static void start() {
        if (!hasStarted) {
            hasStarted = true;
            rTimer.schedule((TimerTask)new QueueTimerTask(), 0L, (long)(Metrics.FLUSH_PERIOD * 1000));
        }
    }

    @Override
    public void run() {
        hasStarted = true;
        if (Notifier.queueList.size() > 0) {
            Queues queues = new Queues(Notifier.config.environment, Notifier.queueList);
            Notifier.queueList = new ArrayList<Object>();
            CompletableFuture<ApmResponse> future = new OkAsyncSender(Notifier.config).send(OkSender.gson.toJson(queues), Constant.apmQueue);
            future.whenComplete((value, exception) -> {
                if (exception != null) {
                    Queues.status = exception.getMessage();
                } else if (value != null) {
                    Queues.status = value.message;
                }
            });
        }
    }

    public static void stop() {
        rTimer.cancel();
    }
}

