/*
 * Decompiled with CFR 0.152.
 */
package io.airbrake.javabrake;

import io.airbrake.javabrake.Span;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Metrics {
    public static int FLUSH_PERIOD = 15;
    Date startTime = new Date();
    Date endTime;
    Map<String, Span> spans = new HashMap<String, Span>();
    Span currSpan;
    Map<String, Long> groups = new HashMap<String, Long>();

    public void end() {
        if (this.endTime == null) {
            this.endTime = new Date();
        }
    }

    protected Span newSpan(String name, Date startTime) {
        return new Span(this, name, startTime);
    }

    public void startSpan(String name, Date startTime) {
        Span span;
        if (this.currSpan != null) {
            if (this.currSpan.name == name) {
                ++this.currSpan.level;
                return;
            }
            this.currSpan.pause();
        }
        if ((span = this.spans.get(name)) == null) {
            span = this.newSpan(name, startTime);
            this.spans.put(name, span);
        } else {
            span.resume();
        }
        span.parent = this.currSpan;
        this.currSpan = span;
    }

    public void endSpan(String name, Date endTime) {
        if (this.currSpan != null && this.currSpan.name == name && this._endSpan(this.currSpan, endTime)) {
            this.currSpan = this.currSpan.parent;
            if (this.currSpan != null) {
                this.currSpan.resume();
            }
            return;
        }
        Span span = this.spans.get(name);
        if (span == null) {
            return;
        }
        this._endSpan(span, endTime);
    }

    protected boolean _endSpan(Span span, Date endTime) {
        if (span.level > 0) {
            --span.level;
            return false;
        }
        span.end(endTime);
        this.spans.remove(span.name);
        return true;
    }

    protected void _inc_group(String name, long ms) {
        if (ms <= 0L) {
            ms = 1L;
        }
        this.groups.put(name, this.groups.getOrDefault(name, 0L) + ms);
    }
}

