/*
 * Decompiled with CFR 0.152.
 */
package fr.devnied.bitlib;

import java.math.BigInteger;

public final class BytesUtils {
    private static final int MAX_BIT_INTEGER = 31;
    private static final int HEXA = 16;
    private static final int LEFT_MASK = 240;
    private static final int RIGHT_MASK = 15;
    private static final int CHAR_DIGIT_ZERO = 48;
    private static final int CHAR_DIGIT_SEVEN = 55;
    private static final char CHAR_SPACE = ' ';

    public static int byteArrayToInt(byte[] byteArray) {
        if (byteArray == null) {
            throw new IllegalArgumentException("Parameter 'byteArray' cannot be null");
        }
        return BytesUtils.byteArrayToInt(byteArray, 0, byteArray.length);
    }

    public static int byteArrayToInt(byte[] byteArray, int startPos, int length) {
        if (byteArray == null) {
            throw new IllegalArgumentException("Parameter 'byteArray' cannot be null");
        }
        if (length <= 0 || length > 4) {
            throw new IllegalArgumentException("Length must be between 1 and 4. Length = " + length);
        }
        if (startPos < 0 || byteArray.length < startPos + length) {
            throw new IllegalArgumentException("Length or startPos not valid");
        }
        int value = 0;
        for (int i = 0; i < length; ++i) {
            value += (byteArray[startPos + i] & 0xFF) << 8 * (length - i - 1);
        }
        return value;
    }

    public static String bytesToString(byte[] pBytes) {
        return BytesUtils.formatByte(pBytes, true, false);
    }

    public static String bytesToString(byte[] pBytes, boolean pTruncate) {
        return BytesUtils.formatByte(pBytes, true, pTruncate);
    }

    public static String bytesToStringNoSpace(byte pByte) {
        return BytesUtils.formatByte(new byte[]{pByte}, false, false);
    }

    public static String bytesToStringNoSpace(byte[] pBytes) {
        return BytesUtils.formatByte(pBytes, false, false);
    }

    public static String bytesToStringNoSpace(byte[] pBytes, boolean pTruncate) {
        return BytesUtils.formatByte(pBytes, false, pTruncate);
    }

    private static String formatByte(byte[] pByte, boolean pSpace, boolean pTruncate) {
        String result;
        if (pByte == null) {
            result = "";
        } else {
            int i;
            if (pTruncate) {
                for (i = 0; i < pByte.length && pByte[i] == 0; ++i) {
                }
            }
            if (i < pByte.length) {
                int sizeMultiplier = pSpace ? 3 : 2;
                char[] c = new char[(pByte.length - i) * sizeMultiplier];
                int j = 0;
                while (i < pByte.length) {
                    byte b = (byte)((pByte[i] & 0xF0) >> 4);
                    c[j] = (char)(b > 9 ? b + 55 : b + 48);
                    b = (byte)(pByte[i] & 0xF);
                    c[++j] = (char)(b > 9 ? b + 55 : b + 48);
                    if (pSpace) {
                        c[++j] = 32;
                    }
                    ++i;
                    ++j;
                }
                result = pSpace ? new String(c, 0, c.length - 1) : new String(c);
            } else {
                result = "";
            }
        }
        return result;
    }

    public static byte[] fromString(String pData) {
        if (pData == null) {
            throw new IllegalArgumentException("Argument can't be null");
        }
        StringBuilder sb = new StringBuilder(pData);
        int j = 0;
        for (int i = 0; i < sb.length(); ++i) {
            if (Character.isWhitespace(sb.charAt(i))) continue;
            sb.setCharAt(j++, sb.charAt(i));
        }
        sb.delete(j, sb.length());
        if (sb.length() % 2 != 0) {
            throw new IllegalArgumentException("Hex binary needs to be even-length :" + pData);
        }
        byte[] result = new byte[sb.length() / 2];
        j = 0;
        for (int i = 0; i < sb.length(); i += 2) {
            result[j++] = (byte)((Character.digit(sb.charAt(i), 16) << 4) + Character.digit(sb.charAt(i + 1), 16));
        }
        return result;
    }

    public static boolean matchBitByBitIndex(int pVal, int pBitIndex) {
        if (pBitIndex < 0 || pBitIndex > 31) {
            throw new IllegalArgumentException("parameter 'pBitIndex' must be between 0 and 31. pBitIndex=" + pBitIndex);
        }
        return (pVal & 1 << pBitIndex) != 0;
    }

    public static byte setBit(byte pData, int pBitIndex, boolean pOn) {
        if (pBitIndex < 0 || pBitIndex > 7) {
            throw new IllegalArgumentException("parameter 'pBitIndex' must be between 0 and 7. pBitIndex=" + pBitIndex);
        }
        byte ret = pData;
        ret = pOn ? (byte)(ret | 1 << pBitIndex) : (byte)(ret & ~(1 << pBitIndex));
        return ret;
    }

    public static String toBinary(byte[] pBytes) {
        String ret = null;
        if (pBytes != null && pBytes.length > 0) {
            BigInteger val = new BigInteger(BytesUtils.bytesToStringNoSpace(pBytes), 16);
            StringBuilder build = new StringBuilder(val.toString(2));
            for (int i = build.length(); i < pBytes.length * 8; ++i) {
                build.insert(0, 0);
            }
            ret = build.toString();
        }
        return ret;
    }

    public static byte[] toByteArray(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    private BytesUtils() {
    }
}

