/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Exposed;
import com.google.inject.Key;
import com.google.inject.PrivateBinder;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.internal.BindingImpl;
import com.google.inject.internal.BytecodeGen;
import com.google.inject.internal.ConstructionContext;
import com.google.inject.internal.DelayedInitialize;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.Exceptions;
import com.google.inject.internal.InjectorImpl;
import com.google.inject.internal.InternalContext;
import com.google.inject.internal.InternalFactory;
import com.google.inject.internal.ProviderInstanceBindingImpl;
import com.google.inject.internal.ProvisionListenerStackCallback;
import com.google.inject.internal.Scoping;
import com.google.inject.internal.SingleParameterInjector;
import com.google.inject.internal.cglib.core.$CodeGenerationException;
import com.google.inject.internal.cglib.reflect.$FastClass;
import com.google.inject.internal.util.StackTraceElements;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderWithExtensionVisitor;
import com.google.inject.spi.ProvidesMethodBinding;
import com.google.inject.spi.ProvidesMethodTargetVisitor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;

public abstract class ProviderMethod<T>
implements ProviderWithExtensionVisitor<T>,
HasDependencies,
ProvidesMethodBinding<T> {
    protected final Object instance;
    protected final Method method;
    private final Key<T> key;
    private final Class<? extends Annotation> scopeAnnotation;
    private final ImmutableSet<Dependency<?>> dependencies;
    private final List<Provider<?>> parameterProviders;
    private final boolean exposed;
    private final Annotation annotation;

    static <T> ProviderMethod<T> create(Key<T> key, Method method, Object instance, ImmutableSet<Dependency<?>> dependencies, List<Provider<?>> parameterProviders, Class<? extends Annotation> scopeAnnotation, boolean skipFastClassGeneration, Annotation annotation) {
        int modifiers = method.getModifiers();
        if (!skipFastClassGeneration) {
            try {
                $FastClass fc = BytecodeGen.newFastClassForMember(method);
                if (fc != null) {
                    return new FastClassProviderMethod<T>(key, fc, method, instance, dependencies, parameterProviders, scopeAnnotation, annotation);
                }
            }
            catch ($CodeGenerationException $CodeGenerationException) {
                // empty catch block
            }
        }
        if (!Modifier.isPublic(modifiers) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
        return new ReflectionProviderMethod<T>(key, method, instance, dependencies, parameterProviders, scopeAnnotation, annotation);
    }

    private ProviderMethod(Key<T> key, Method method, Object instance, ImmutableSet<Dependency<?>> dependencies, List<Provider<?>> parameterProviders, Class<? extends Annotation> scopeAnnotation, Annotation annotation) {
        this.key = key;
        this.scopeAnnotation = scopeAnnotation;
        this.instance = instance;
        this.dependencies = dependencies;
        this.method = method;
        this.parameterProviders = parameterProviders;
        this.exposed = method.isAnnotationPresent(Exposed.class);
        this.annotation = annotation;
    }

    @Override
    public Key<T> getKey() {
        return this.key;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    public Object getInstance() {
        return this.instance;
    }

    @Override
    public Object getEnclosingInstance() {
        return this.instance;
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void configure(Binder binder) {
        binder = binder.withSource(this.method);
        if (this.scopeAnnotation != null) {
            binder.bind(this.key).toProvider(this).in(this.scopeAnnotation);
        } else {
            binder.bind(this.key).toProvider(this);
        }
        if (this.exposed) {
            ((PrivateBinder)binder).expose(this.key);
        }
    }

    @Override
    public T get() {
        Object[] parameters = new Object[this.parameterProviders.size()];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.parameterProviders.get(i).get();
        }
        try {
            return this.doProvision(parameters);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw Exceptions.rethrowCause(e);
        }
    }

    abstract T doProvision(Object[] var1) throws IllegalAccessException, InvocationTargetException;

    @Override
    public Set<Dependency<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public <B, V> V acceptExtensionVisitor(BindingTargetVisitor<B, V> visitor, ProviderInstanceBinding<? extends B> binding) {
        if (visitor instanceof ProvidesMethodTargetVisitor) {
            return ((ProvidesMethodTargetVisitor)visitor).visit(this);
        }
        return visitor.visit(binding);
    }

    public String toString() {
        String annotationString = this.annotation.toString();
        if (this.annotation.annotationType() == Provides.class) {
            annotationString = "@Provides";
        } else if (annotationString.endsWith("()")) {
            annotationString = annotationString.substring(0, annotationString.length() - 2);
        }
        return annotationString + " " + StackTraceElements.forMember(this.method);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProviderMethod) {
            ProviderMethod o = (ProviderMethod)obj;
            return this.method.equals(o.method) && this.instance.equals(o.instance) && this.annotation.equals(o.annotation);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.method, this.annotation);
    }

    static <T> BindingImpl<T> createBinding(InjectorImpl injector, Key<T> key, ProviderMethod<T> providerMethod, Object source2, Scoping scoping) {
        Factory<T> factory2 = new Factory<T>(source2, providerMethod);
        InternalFactory<T> scopedFactory = Scoping.scope(key, injector, factory2, source2, scoping);
        return new ProviderMethodProviderInstanceBindingImpl<T>(injector, key, source2, scopedFactory, scoping, providerMethod, factory2);
    }

    private static final class Factory<T>
    implements InternalFactory<T> {
        private final Object source;
        private final ProviderMethod<T> providerMethod;
        private ProvisionListenerStackCallback<T> provisionCallback;
        private SingleParameterInjector<?>[] parameterInjectors;

        Factory(Object source2, ProviderMethod<T> providerMethod) {
            this.source = source2;
            this.providerMethod = providerMethod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(final Errors errors, final InternalContext context, final Dependency<?> dependency, boolean linked) throws ErrorsException {
            final ConstructionContext constructionContext = context.getConstructionContext(this);
            if (constructionContext.isConstructing()) {
                Class<?> expectedType = dependency.getKey().getTypeLiteral().getRawType();
                Object proxyType = constructionContext.createProxy(errors, context.getInjectorOptions(), expectedType);
                return (T)proxyType;
            }
            constructionContext.startConstruction();
            try {
                if (!this.provisionCallback.hasListeners()) {
                    Object t = this.provision(errors, dependency, context, constructionContext);
                    return t;
                }
                T t = this.provisionCallback.provision(errors, context, new ProvisionListenerStackCallback.ProvisionCallback<T>(){

                    @Override
                    public T call() throws ErrorsException {
                        return Factory.this.provision(errors, dependency, context, constructionContext);
                    }
                });
                return t;
            }
            finally {
                constructionContext.removeCurrentReference();
                constructionContext.finishConstruction();
            }
        }

        T provision(Errors errors, Dependency<?> dependency, InternalContext context, ConstructionContext<T> constructionContext) throws ErrorsException {
            try {
                T t = this.providerMethod.doProvision(SingleParameterInjector.getAll(errors, context, this.parameterInjectors));
                errors.checkForNull(t, this.providerMethod.getMethod(), dependency);
                constructionContext.setProxyDelegates(t);
                return t;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException userException) {
                Throwable cause = userException.getCause() != null ? userException.getCause() : userException;
                throw errors.withSource(this.source).errorInProvider(cause).toException();
            }
        }

        public String toString() {
            return this.providerMethod.toString();
        }

        static /* synthetic */ SingleParameterInjector[] access$102(Factory x0, SingleParameterInjector[] x1) {
            x0.parameterInjectors = x1;
            return x1;
        }
    }

    private static final class ProviderMethodProviderInstanceBindingImpl<T>
    extends ProviderInstanceBindingImpl<T>
    implements DelayedInitialize {
        final Factory<T> factory;

        ProviderMethodProviderInstanceBindingImpl(InjectorImpl injector, Key<T> key, Object source2, InternalFactory<? extends T> internalFactory, Scoping scoping, ProviderMethod<T> providerInstance, Factory<T> factory2) {
            super(injector, key, source2, internalFactory, scoping, providerInstance, ImmutableSet.<InjectionPoint>of());
            this.factory = factory2;
        }

        @Override
        public void initialize(InjectorImpl injector, Errors errors) throws ErrorsException {
            Factory.access$102(this.factory, injector.getParametersInjectors(((Factory)this.factory).providerMethod.dependencies.asList(), errors));
            ((Factory)this.factory).provisionCallback = injector.provisionListenerStore.get(this);
        }
    }

    private static final class ReflectionProviderMethod<T>
    extends ProviderMethod<T> {
        ReflectionProviderMethod(Key<T> key, Method method, Object instance, ImmutableSet<Dependency<?>> dependencies, List<Provider<?>> parameterProviders, Class<? extends Annotation> scopeAnnotation, Annotation annotation) {
            super(key, method, instance, dependencies, parameterProviders, scopeAnnotation, annotation);
        }

        @Override
        T doProvision(Object[] parameters) throws IllegalAccessException, InvocationTargetException {
            return (T)this.method.invoke(this.instance, parameters);
        }
    }

    private static final class FastClassProviderMethod<T>
    extends ProviderMethod<T> {
        final $FastClass fastClass;
        final int methodIndex;

        FastClassProviderMethod(Key<T> key, $FastClass fc, Method method, Object instance, ImmutableSet<Dependency<?>> dependencies, List<Provider<?>> parameterProviders, Class<? extends Annotation> scopeAnnotation, Annotation annotation) {
            super(key, method, instance, dependencies, parameterProviders, scopeAnnotation, annotation);
            this.fastClass = fc;
            this.methodIndex = fc.getMethod(method).getIndex();
        }

        @Override
        public T doProvision(Object[] parameters) throws IllegalAccessException, InvocationTargetException {
            return (T)this.fastClass.invoke(this.methodIndex, this.instance, parameters);
        }
    }
}

